/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.common.actor;

import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.cluster.common.actor.AbstractConfig;
import scala.concurrent.duration.FiniteDuration;

public class CommonConfig
extends AbstractConfig {
    protected static final String TAG_ACTOR_SYSTEM_NAME = "actor-system-name";
    protected static final String TAG_METRIC_CAPTURE_ENABLED = "metric-capture-enabled";
    protected static final String TAG_MAILBOX_CAPACITY = "mailbox-capacity";
    protected static final String TAG_MAILBOX = "bounded-mailbox";
    protected static final String TAG_MAILBOX_PUSH_TIMEOUT = "mailbox-push-timeout-time";
    private static final int DEFAULT_MAILBOX_CAPACITY = 1000;
    private static final int DEFAULT_MAILBOX_PUSH_TIMEOUT = 100;
    private FiniteDuration cachedMailBoxPushTimeout;
    private Integer cachedMailBoxCapacity;
    private Boolean cachedMetricCaptureEnableFlag;

    public CommonConfig(Config config) {
        super(config);
    }

    public String getActorSystemName() {
        return this.get().getString(TAG_ACTOR_SYSTEM_NAME);
    }

    public boolean isMetricCaptureEnabled() {
        if (this.cachedMetricCaptureEnableFlag != null) {
            return this.cachedMetricCaptureEnableFlag;
        }
        this.cachedMetricCaptureEnableFlag = this.get().hasPath(TAG_METRIC_CAPTURE_ENABLED) ? this.get().getBoolean(TAG_METRIC_CAPTURE_ENABLED) : false;
        return this.cachedMetricCaptureEnableFlag;
    }

    public String getMailBoxName() {
        return TAG_MAILBOX;
    }

    public Integer getMailBoxCapacity() {
        if (this.cachedMailBoxCapacity != null) {
            return this.cachedMailBoxCapacity;
        }
        String PATH = "bounded-mailbox.mailbox-capacity";
        this.cachedMailBoxCapacity = this.get().hasPath("bounded-mailbox.mailbox-capacity") ? this.get().getInt("bounded-mailbox.mailbox-capacity") : 1000;
        return this.cachedMailBoxCapacity;
    }

    public FiniteDuration getMailBoxPushTimeout() {
        if (this.cachedMailBoxPushTimeout != null) {
            return this.cachedMailBoxPushTimeout;
        }
        String PATH = "bounded-mailbox.mailbox-push-timeout-time";
        long timeout = this.get().hasPath("bounded-mailbox.mailbox-push-timeout-time") ? this.get().getDuration("bounded-mailbox.mailbox-push-timeout-time", TimeUnit.NANOSECONDS) : 100L;
        this.cachedMailBoxPushTimeout = FiniteDuration.create((long)timeout, (TimeUnit)TimeUnit.NANOSECONDS);
        return this.cachedMailBoxPushTimeout;
    }

    public static class Builder<T extends Builder<T>>
    extends AbstractConfig.Builder<T> {
        public Builder(String actorSystemName) {
            super(actorSystemName);
            this.configHolder.put(CommonConfig.TAG_ACTOR_SYSTEM_NAME, actorSystemName);
            this.configHolder.put(CommonConfig.TAG_MAILBOX, new HashMap());
        }

        public T metricCaptureEnabled(boolean enabled) {
            this.configHolder.put(CommonConfig.TAG_METRIC_CAPTURE_ENABLED, String.valueOf(enabled));
            return (T)this;
        }

        public T mailboxCapacity(int capacity) {
            Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"mailbox capacity must be >0");
            Map boundedMailbox = (Map)this.configHolder.get(CommonConfig.TAG_MAILBOX);
            boundedMailbox.put(CommonConfig.TAG_MAILBOX_CAPACITY, capacity);
            return (T)this;
        }

        public T mailboxPushTimeout(String timeout) {
            Preconditions.checkArgument((boolean)FiniteDuration.create((String)timeout).isFinite(), (String)"invalid value \"%s\" for mailbox push timeout", (Object)timeout);
            Map boundedMailbox = (Map)this.configHolder.get(CommonConfig.TAG_MAILBOX);
            boundedMailbox.put(CommonConfig.TAG_MAILBOX_PUSH_TIMEOUT, timeout);
            return (T)this;
        }

        public CommonConfig build() {
            return new CommonConfig(this.merge());
        }
    }
}

