/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.maven.command;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.karaf.maven.core.MavenRepositoryURL;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.console.Session;
import org.apache.karaf.shell.support.table.Row;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.osgi.framework.BundleContext;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public abstract class MavenConfigurationSupport
implements Action {
    public static Logger LOG = LoggerFactory.getLogger(MavenConfigurationSupport.class);
    protected static final String PID = "org.ops4j.pax.url.mvn";
    protected static final String PATTERN_PID_PROPERTY = "Explicit %s PID configuration (%s)";
    protected static final String PATTERN_SECURITY_SETTINGS = "maven-security-settings-%d.xml";
    protected static final Pattern RE_SECURITY_SETTINGS = Pattern.compile("maven-security-settings-(\\d+)\\.xml");
    protected static final String PATTERN_SETTINGS = "maven-settings-%d.xml";
    protected static final Pattern RE_SETTINGS = Pattern.compile("maven-settings-(\\d+)\\.xml");
    private static final int MAX_SEQUENCE_SIZE = 10;
    protected static final String PROPERTY_LOCAL_REPOSITORY = "localRepository";
    protected static final String PROPERTY_DEFAULT_REPOSITORIES = "defaultRepositories";
    protected static final String PROPERTY_REPOSITORIES = "repositories";
    protected static final String PROPERTY_SETTINGS_FILE = "settings";
    protected static final String PROPERTY_SECURITY_FILE = "security";
    protected static final String PROPERTY_GLOBAL_UPDATE_POLICY = "globalUpdatePolicy";
    protected static final String PROPERTY_GLOBAL_CHECKSUM_POLICY = "globalChecksumPolicy";
    protected static final String PROPERTY_UPDATE_RELEASES = "updateReleases";
    protected static final String REQUIRE_CONFIG_ADMIN_CONFIG = "requireConfigAdminConfig";
    protected static final String PROPERTY_USE_FALLBACK_REPOSITORIES = "useFallbackRepositories";
    protected static final String PROPERTY_OFFLINE = "offline";
    protected static final String PROPERTY_CERTIFICATE_CHECK = "certificateCheck";
    protected static final String PROPERTY_TIMEOUT = "timeout";
    protected static final String PROPERTY_SOCKET_SO_TIMEOUT = "socket.readTimeout";
    protected static final String PROPERTY_SOCKET_SO_KEEPALIVE = "socket.keepAlive";
    protected static final String PROPERTY_SOCKET_SO_LINGER = "socket.linger";
    protected static final String PROPERTY_SOCKET_SO_REUSEADDRESS = "socket.reuseAddress";
    protected static final String PROPERTY_SOCKET_TCP_NODELAY = "socket.tcpNoDelay";
    protected static final String PROPERTY_SOCKET_CONNECTION_TIMEOUT = "socket.connectionTimeout";
    protected static final String PROPERTY_CONNECTION_BUFFER_SIZE = "connection.bufferSize";
    protected static final String PROPERTY_CONNECTION_RETRY_COUNT = "connection.retryCount";
    protected SourceAnd<File> localRepository;
    protected SourceAnd<File> settings;
    protected Settings mavenSettings;
    protected SourceAnd<File> securitySettings;
    protected SettingsSecurity mavenSecuritySettings;
    protected Map<String, Server> servers = new HashMap<String, Server>();
    protected Map<String, String> serverPasswords = new HashMap<String, String>();
    protected Map<String, String> proxyPasswords = new HashMap<String, String>();
    protected List<String> warnings = new LinkedList<String>();
    private static final String masterMasterPassword = "settings.security";
    protected String masterPassword;
    protected DefaultPlexusCipher cipher;
    @Reference
    protected ConfigurationAdmin cm;
    @Reference
    protected BundleContext context;
    @Reference
    protected Session session;

    public final Object execute() throws Exception {
        Configuration c = this.cm.getConfiguration(PID);
        if (c != null && c.getProperties() != null) {
            try {
                this.cipher = new DefaultPlexusCipher();
                this.securitySettings = this.securitySettings((String)c.getProperties().get("org.ops4j.pax.url.mvn.security"));
                if (this.securitySettings != null && this.securitySettings.value != null) {
                    this.mavenSecuritySettings = this.readSecuritySettings((File)this.securitySettings.value);
                }
                this.settings = this.settings((String)c.getProperties().get("org.ops4j.pax.url.mvn.settings"));
                if (this.settings != null && this.settings.value != null) {
                    this.mavenSettings = this.readSettings((File)this.settings.value);
                }
                this.localRepository = this.localRepository((String)c.getProperties().get("org.ops4j.pax.url.mvn.localRepository"));
                if (this.showPasswords()) {
                    this.decryptSettings();
                }
                this.doAction("org.ops4j.pax.url.mvn.", c.getProperties());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                LOG.error(e.getMessage(), (Throwable)e);
            }
        } else {
            System.err.printf("Can't access \"%s\" configuration\n", PID);
        }
        return null;
    }

    protected abstract void doAction(String var1, Dictionary<String, Object> var2) throws Exception;

    protected SourceAnd<File> settings(String cmProperty) {
        String probableErrorMessage;
        URL locationUrl;
        SourceAnd<File> result;
        block9: {
            result = new SourceAnd<File>();
            locationUrl = null;
            probableErrorMessage = null;
            if (cmProperty != null && !"".equals(cmProperty.trim())) {
                result.source = String.format(PATTERN_PID_PROPERTY, PID, "org.ops4j.pax.url.mvn.settings");
                try {
                    locationUrl = new URL(cmProperty);
                    probableErrorMessage = String.format("%s configured in %s.%s is not accessible", locationUrl, PID, PROPERTY_SETTINGS_FILE);
                }
                catch (MalformedURLException e) {
                    File file = new File(cmProperty);
                    if (!file.isFile()) break block9;
                    result.value = file;
                    return result;
                }
            }
        }
        if (locationUrl == null) {
            File file = new File(System.getProperty("user.home") + "/.m2/settings.xml");
            if (file.isFile()) {
                result.value = file;
                result.source = "Implicit ${user.home}/.m2/settings.xml";
                return result;
            }
            file = new File(System.getProperty("maven.home") + "/conf/settings.xml");
            if (file.isFile()) {
                result.value = file;
                result.source = "Implicit ${maven.home}/conf/settings.xml";
                return result;
            }
            file = new File(System.getenv("M2_HOME") + "/conf/settings.xml");
            if (file.isFile()) {
                result.value = file;
                result.source = "Implicit $M2_HOME/conf/settings.xml";
                return result;
            }
        } else {
            File file = new File(locationUrl.getPath());
            result.value = file;
            if (!file.isFile()) {
                result.source = probableErrorMessage;
            }
            return result;
        }
        result.value = null;
        result.source = "No implicit settings.xml location is available";
        return result;
    }

    protected SourceAnd<File> securitySettings(String cmProperty) {
        String probableErrorMessage;
        URL locationUrl;
        SourceAnd<File> result;
        block7: {
            result = new SourceAnd<File>();
            locationUrl = null;
            probableErrorMessage = null;
            if (cmProperty != null && !"".equals(cmProperty.trim())) {
                result.source = String.format(PATTERN_PID_PROPERTY, PID, "org.ops4j.pax.url.mvn.security");
                try {
                    locationUrl = new URL(cmProperty);
                    probableErrorMessage = String.format("%s configured in %s.%s is not accessible", locationUrl, PID, PROPERTY_SECURITY_FILE);
                }
                catch (MalformedURLException e) {
                    File file = new File(cmProperty);
                    if (!file.isFile()) break block7;
                    result.value = file;
                    return result;
                }
            }
        }
        if (locationUrl == null) {
            File file = new File(System.getProperty("user.home") + "/.m2/settings-security.xml");
            if (file.isFile()) {
                result.value = file;
                result.source = "Implicit ${user.home}/.m2/settings-security.xml";
                return result;
            }
        } else {
            File file = new File(locationUrl.getPath());
            result.value = file;
            if (!file.isFile()) {
                result.source = probableErrorMessage;
            }
        }
        result.value = null;
        result.source = "No implicit settings-security.xml location is available";
        return result;
    }

    protected SourceAnd<File> localRepository(String cmProperty) {
        File file;
        String probableErrorMessage;
        URL locationUrl;
        SourceAnd<File> result;
        block9: {
            File file2;
            block8: {
                result = new SourceAnd<File>();
                locationUrl = null;
                probableErrorMessage = null;
                if (cmProperty != null && !"".equals(cmProperty.trim())) {
                    result.source = String.format(PATTERN_PID_PROPERTY, PID, "org.ops4j.pax.url.mvn.localRepository");
                    try {
                        locationUrl = new URL(cmProperty);
                        probableErrorMessage = String.format("%s configured in %s.%s is not accessible", locationUrl, PID, PROPERTY_LOCAL_REPOSITORY);
                    }
                    catch (MalformedURLException e) {
                        file2 = new File(cmProperty);
                        if (!file2.isDirectory()) break block8;
                        result.value = file2;
                        return result;
                    }
                }
            }
            if (locationUrl == null && this.mavenSettings != null && this.mavenSettings.getLocalRepository() != null) {
                result.source = String.format("Explicit <localRepository> in %s", this.settings.value);
                try {
                    locationUrl = new URL(this.mavenSettings.getLocalRepository());
                    probableErrorMessage = String.format("%s configured in %s is not accessible", this.mavenSettings.getLocalRepository(), this.settings.value);
                }
                catch (MalformedURLException e) {
                    file2 = new File(this.mavenSettings.getLocalRepository());
                    if (!file2.isDirectory()) break block9;
                    result.value = file2;
                    return result;
                }
            }
        }
        if (locationUrl == null) {
            file = new File(System.getProperty("user.home") + "/.m2/repository");
            result.value = file;
            result.source = file.isDirectory() ? "Implicit ${user.home}/.m2/repository" : "Implicit ${user.home}/.m2/repository (not accessible)";
            return result;
        }
        file = new File(locationUrl.getPath());
        result.value = file;
        if (!file.isDirectory()) {
            result.source = probableErrorMessage;
        }
        return result;
    }

    protected synchronized Settings readSettings(File settingsFile) throws SettingsBuildingException {
        if (!settingsFile.isFile() || !settingsFile.canRead()) {
            return null;
        }
        try {
            DefaultSettingsBuilderFactory factory = new DefaultSettingsBuilderFactory();
            DefaultSettingsBuilder builder = factory.newInstance();
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
            request.setUserSettingsFile(settingsFile);
            SettingsBuildingResult result = builder.build(request);
            if (result.getProblems().size() > 0) {
                for (SettingsProblem problem : result.getProblems()) {
                    System.err.println(problem);
                }
                return null;
            }
            Settings settings = result.getEffectiveSettings();
            if (settings.getServers() != null) {
                for (Server server : settings.getServers()) {
                    this.servers.put(server.getId(), server);
                }
            }
            return settings;
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            LOG.error(e.getMessage(), e);
            throw e;
        }
    }

    protected synchronized SettingsSecurity readSecuritySettings(File securitySettingsFile) throws Exception {
        if (!securitySettingsFile.isFile() || !securitySettingsFile.canRead()) {
            return null;
        }
        try {
            return SecUtil.read(securitySettingsFile.getAbsolutePath(), true);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            LOG.error(e.getMessage(), e);
            throw e;
        }
    }

    private void decryptSettings() throws Exception {
        if (this.mavenSecuritySettings != null && this.mavenSettings != null) {
            this.masterPassword = this.cipher.decryptDecorated(this.mavenSecuritySettings.getMaster(), masterMasterPassword);
            DefaultSecDispatcher dispatcher = new DefaultSecDispatcher(this.cipher);
            DefaultSettingsDecrypter decrypter = new DefaultSettingsDecrypter(new DefaultSecDispatcher(this.cipher));
            try {
                dispatcher.setConfigurationFile(((File)this.securitySettings.value).getAbsolutePath());
                Field f = dispatcher.getClass().getDeclaredField("_cipher");
                f.setAccessible(true);
                f.set(dispatcher, this.cipher);
                f = decrypter.getClass().getDeclaredField("securityDispatcher");
                f.setAccessible(true);
                f.set(decrypter, dispatcher);
                DefaultSettingsDecryptionRequest req = new DefaultSettingsDecryptionRequest(this.mavenSettings);
                SettingsDecryptionResult res = decrypter.decrypt(req);
                if (res.getProblems() != null && res.getProblems().size() > 0) {
                    for (SettingsProblem sp : res.getProblems()) {
                        System.err.println(sp);
                    }
                }
                for (Proxy proxy : res.getProxies()) {
                    if (this.cipher.isEncryptedString(proxy.getPassword())) continue;
                    this.proxyPasswords.put(proxy.getId(), proxy.getPassword());
                }
                for (Server server : res.getServers()) {
                    if (this.cipher.isEncryptedString(server.getPassword())) continue;
                    this.serverPasswords.put(server.getId(), server.getPassword());
                }
            }
            catch (Throwable t) {
                LOG.warn("Can't decrypt " + this.securitySettings.value, t);
            }
        }
    }

    protected MavenRepositoryURL[] repositories(Dictionary<String, Object> config, boolean remote) throws Exception {
        String property = remote ? "org.ops4j.pax.url.mvn.repositories" : "org.ops4j.pax.url.mvn.defaultRepositories";
        String[] repositories = this.listOfValues((String)config.get(property));
        if (remote && (repositories.length == 0 || repositories[0].charAt(0) == '+')) {
            if (repositories.length > 0) {
                repositories[0] = repositories[0].substring(1);
            }
            LinkedList<String> newRepositories = new LinkedList<String>(Arrays.asList(repositories));
            if (this.mavenSettings != null) {
                LinkedHashSet<String> activeProfiles = new LinkedHashSet<String>(this.mavenSettings.getActiveProfiles());
                Map<String, Profile> profiles = this.mavenSettings.getProfilesAsMap();
                profiles.values().stream().filter(profile -> profile.getActivation() != null && profile.getActivation().isActiveByDefault()).map(IdentifiableBase::getId).forEach(activeProfiles::add);
                for (String activeProfile : activeProfiles) {
                    Profile profile2 = profiles.get(activeProfile);
                    if (profile2 == null) continue;
                    for (Repository repo : profile2.getRepositories()) {
                        SourceAnd<String> up;
                        StringBuilder builder = new StringBuilder();
                        builder.append(repo.getUrl());
                        builder.append("@id=").append(repo.getId());
                        builder.append("@_from=").append((Object)MavenRepositoryURL.FROM.SETTINGS);
                        if (repo.getReleases() != null) {
                            if (!repo.getReleases().isEnabled()) {
                                builder.append("@").append("noreleases");
                            }
                            this.addPolicy(builder, "".equals((up = this.updatePolicy(repo.getReleases().getUpdatePolicy())).val()) ? "never" : up.val(), "releasesUpdate");
                        }
                        if (repo.getSnapshots() != null) {
                            if (repo.getSnapshots().isEnabled()) {
                                builder.append("@").append("snapshots");
                            }
                            this.addPolicy(builder, "".equals((up = this.updatePolicy(repo.getSnapshots().getUpdatePolicy())).val()) ? "never" : up.val(), "snapshotsUpdate");
                        }
                        newRepositories.add(builder.toString());
                    }
                }
            }
            repositories = newRepositories.toArray(new String[newRepositories.size()]);
        }
        LinkedList<MavenRepositoryURL> result = new LinkedList<MavenRepositoryURL>();
        for (String repo : repositories) {
            result.add(new MavenRepositoryURL(repo));
        }
        return result.toArray(new MavenRepositoryURL[result.size()]);
    }

    private void addPolicy(StringBuilder builder, String policy, String option) {
        if (policy != null && !policy.isEmpty()) {
            builder.append("@");
            builder.append(option);
            builder.append("=");
            builder.append(policy);
        }
    }

    protected String[] listOfValues(String list) {
        if (list == null) {
            return new String[0];
        }
        String[] values = list.split("\\s*,\\s*");
        return (String[])Arrays.stream(values).filter(value -> value != null && !"".equals(value.trim())).toArray(String[]::new);
    }

    protected void addPasswordInfo(Row row, Map<String, String> id2Password, String id, String password) {
        if (id2Password.containsKey(id)) {
            row.addContent(new Object[]{id2Password.get(id)});
        } else if (this.cipher.isEncryptedString(password)) {
            row.addContent(new Object[]{password + " (can't decrypt)"});
        } else {
            row.addContent(new Object[]{password == null ? "" : password});
        }
    }

    protected boolean confirm(String prompt) throws IOException {
        String response = this.session.readLine(prompt, null);
        return "y".equals(response);
    }

    protected File nextSequenceFile(File dataDir, Pattern pattern, String fileNameFormat) {
        File[] files = dataDir.listFiles((dir, name) -> pattern.matcher(name).matches());
        File result = null;
        if (files != null && files.length > 0) {
            ArrayList<String> names = new ArrayList<String>(Arrays.stream(files).map(File::getName).collect(TreeSet::new, TreeSet::add, TreeSet::addAll));
            names.add(String.format(fileNameFormat, System.currentTimeMillis()));
            while (names.size() > 10) {
                String name2 = (String)names.remove(0);
                new File(dataDir, name2).delete();
            }
            result = new File(dataDir, (String)names.get(names.size() - 1));
        }
        if (result == null) {
            result = new File(dataDir, String.format(fileNameFormat, new Date().getTime()));
        }
        return result;
    }

    protected boolean showPasswords() {
        return false;
    }

    protected SourceAnd<String> updatePolicy(String policy) {
        SourceAnd<String> result = new SourceAnd<String>();
        result.value = policy;
        if (policy == null || "".equals(policy.trim())) {
            result.value = "";
            result.valid = false;
            result.source = "Implicit \"never\", but doesn't override repository-specific value";
            return result;
        }
        result.source = String.format(PATTERN_PID_PROPERTY, PID, "org.ops4j.pax.url.mvn.globalUpdatePolicy");
        if ("always".equals(policy) || "never".equals(policy) || "daily".equals(policy)) {
            result.valid = true;
        } else if (policy.startsWith("interval")) {
            int minutes = 1440;
            try {
                String n = policy.substring("interval".length() + 1);
                minutes = Integer.parseInt(n);
                result.valid = true;
            }
            catch (Exception e) {
                result.valid = false;
                result.value = "interval:1440";
                result.source = "Implicit \"interval:1440\" (error parsing \"" + policy + "\")";
            }
        } else {
            result.valid = false;
            result.value = "never";
            result.source = "Implicit \"never\" (unknown value \"" + policy + "\")";
        }
        return result;
    }

    protected SourceAnd<String> checksumPolicy(String policy) {
        SourceAnd<String> result = new SourceAnd<String>();
        result.value = policy;
        if (policy == null || "".equals(policy.trim())) {
            result.valid = false;
            result.value = "warn";
            result.source = "Default \"warn\"";
            return result;
        }
        result.source = String.format(PATTERN_PID_PROPERTY, PID, "org.ops4j.pax.url.mvn.globalChecksumPolicy");
        if ("ignore".equals(policy) || "warn".equals(policy) || "fail".equals(policy)) {
            result.valid = true;
        } else {
            result.valid = false;
            result.value = "warn";
            result.source = "Implicit \"warn\" (unknown value \"" + policy + "\")";
        }
        return result;
    }

    protected void updateSettings(String prefix, Dictionary<String, Object> config) throws IOException {
        File dataDir = this.context.getDataFile(".");
        if (!dataDir.isDirectory()) {
            throw new RuntimeException("Can't access data directory for " + this.context.getBundle().getSymbolicName() + " bundle");
        }
        File newSettingsFile = this.nextSequenceFile(dataDir, RE_SETTINGS, PATTERN_SETTINGS);
        config.put(prefix + PROPERTY_SETTINGS_FILE, newSettingsFile.getCanonicalPath());
        try (FileWriter fw = new FileWriter(newSettingsFile);){
            new SettingsXpp3Writer().write(fw, this.mavenSettings);
        }
        System.out.println("New settings stored in \"" + newSettingsFile.getCanonicalPath() + "\"");
    }

    protected static class SourceAnd<T> {
        String source;
        T value;
        boolean valid;

        public SourceAnd() {
        }

        public SourceAnd(String source, T value) {
            this.source = source;
            this.value = value;
        }

        public String val() {
            return this.value == null ? "" : this.value.toString();
        }
    }
}

