/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yang.netty.timer;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.opendaylight.controller.config.yang.netty.timer.HashedWheelTimerCloseable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, configurationPid={"org.opendaylight.netty.timer"}, property={"type=global-timer"})
@Designate(ocd=Config.class)
public final class OSGiGlobalTimer
implements Timer {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiGlobalTimer.class);
    private Timer delegate;

    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        return this.delegate.newTimeout(task, delay, unit);
    }

    public Set<Timeout> stop() {
        return this.delegate.stop();
    }

    @Activate
    void activate(Config config) {
        this.delegate = HashedWheelTimerCloseable.newInstance(config.tickDuration(), config.ticksPerWheel());
        LOG.info("Global Netty timer started");
    }

    @Deactivate
    void deactivate() {
        this.delegate.stop();
        LOG.info("Global Netty timer stopped");
    }

    @ObjectClassDefinition
    public static @interface Config {
        @AttributeDefinition(name="tick-duration")
        public long tickDuration() default 0L;

        @AttributeDefinition(name="ticks-per-wheel")
        public int ticksPerWheel() default 0;
    }
}

