/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecDataObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

public abstract class AugmentableCodecDataObject<T extends DataObject & Augmentable<T>>
extends CodecDataObject<T>
implements Augmentable<T> {
    private static final VarHandle CACHED_AUGMENTATIONS;
    private volatile ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> cachedAugmentations;

    protected AugmentableCodecDataObject(DataObjectCodecContext<T, ?> context, DistinctNodeContainer<?, ?> data) {
        super(context, data);
    }

    public final <A extends Augmentation<T>> @Nullable A augmentation(Class<A> augmentationType) {
        NormalizedNode augData;
        DataContainerCodecContext<A, ?> augCtx;
        Objects.requireNonNull(augmentationType, "Supplied augmentation must not be null.");
        ImmutableMap<Class<Augmentation<T>>, Augmentation<T>> aug = this.acquireAugmentations();
        if (aug != null) {
            return (A)((Augmentation)aug.get(augmentationType));
        }
        Optional<DataContainerCodecContext<A, ?>> optAugCtx = this.codecContext().possibleStreamChild(augmentationType);
        if (optAugCtx.isPresent() && augmentationType.isAssignableFrom((augCtx = optAugCtx.orElseThrow()).getBindingClass()) && (augData = this.codecData().childByArg(augCtx.getDomPathArgument())) != null) {
            return (A)((Augmentation)augCtx.deserialize(augData));
        }
        return null;
    }

    public final ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> augmentations() {
        ImmutableMap<Class<Augmentation<T>>, Augmentation<T>> local = this.acquireAugmentations();
        return local != null ? local : this.loadAugmentations();
    }

    private ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> acquireAugmentations() {
        return CACHED_AUGMENTATIONS.getAcquire(this);
    }

    private ImmutableMap<Class<? extends Augmentation<T>>, Augmentation<T>> loadAugmentations() {
        ImmutableMap ret = ImmutableMap.copyOf(this.codecContext().getAllAugmentationsFrom((DistinctNodeContainer<YangInstanceIdentifier.PathArgument, NormalizedNode>)this.codecData()));
        Object witness = CACHED_AUGMENTATIONS.compareAndExchangeRelease(this, null, ret);
        return witness == null ? ret : (ImmutableMap)witness;
    }

    static {
        try {
            CACHED_AUGMENTATIONS = MethodHandles.lookup().findVarHandle(AugmentableCodecDataObject.class, "cachedAugmentations", ImmutableMap.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

