/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.EntryUtil;
import tech.pantheon.triemap.Result;

abstract class LNodeEntry<K, V>
implements Map.Entry<K, V> {
    private final K key;
    private final V value;

    LNodeEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public final K getKey() {
        return this.key;
    }

    @Override
    public final V getValue() {
        return this.value;
    }

    final @NonNull Result<V> toResult() {
        return new Result<V>(this.value);
    }

    @Override
    public final V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        return EntryUtil.entryHashCode(this.key, this.value);
    }

    @Override
    @SuppressFBWarnings(value={"EQ_UNUSUAL"}, justification="Equality handled by utility methods")
    public final boolean equals(Object obj) {
        return EntryUtil.entryEquals(obj, this.key, this.value);
    }

    public final String toString() {
        return EntryUtil.entryToString(this.key, this.value);
    }
}

