/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import tech.pantheon.triemap.CNode;
import tech.pantheon.triemap.Gen;
import tech.pantheon.triemap.INode;
import tech.pantheon.triemap.ImmutableTrieMap;
import tech.pantheon.triemap.MainNode;
import tech.pantheon.triemap.MutableEntrySet;
import tech.pantheon.triemap.MutableIterator;
import tech.pantheon.triemap.MutableKeySet;
import tech.pantheon.triemap.PresencePredicate;
import tech.pantheon.triemap.Result;
import tech.pantheon.triemap.TrieMap;
import tech.pantheon.triemap.VerifyException;

public final class MutableTrieMap<K, V>
extends TrieMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final VarHandle ROOT;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Handled through writeReplace()")
    private volatile transient Root root;

    MutableTrieMap() {
        this(MutableTrieMap.newRootNode());
    }

    MutableTrieMap(INode<K, V> root) {
        this.root = Objects.requireNonNull(root);
    }

    @Override
    public void clear() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), MutableTrieMap.newRootNode())) {
        }
    }

    @Override
    public V put(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertifhc(k, MutableTrieMap.computeHash(k), Objects.requireNonNull(value), null).orNull();
    }

    @Override
    public V putIfAbsent(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertifhc(k, MutableTrieMap.computeHash(k), Objects.requireNonNull(value), (Object)PresencePredicate.ABSENT).orNull();
    }

    @Override
    public V remove(Object key) {
        Object k = Objects.requireNonNull(key);
        return this.removehc(k, null, MutableTrieMap.computeHash(k)).orNull();
    }

    @Override
    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="API contract allows null value, but we do not")
    public boolean remove(Object key, Object value) {
        Object k = Objects.requireNonNull(key);
        return this.removehc(k, Objects.requireNonNull(value), MutableTrieMap.computeHash(k)).isPresent();
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        K k = Objects.requireNonNull(key);
        return this.insertifhc(k, MutableTrieMap.computeHash(k), Objects.requireNonNull(newValue), Objects.requireNonNull(oldValue)).isPresent();
    }

    @Override
    public V replace(K key, V value) {
        K k = Objects.requireNonNull(key);
        return this.insertifhc(k, MutableTrieMap.computeHash(k), Objects.requireNonNull(value), (Object)PresencePredicate.PRESENT).orNull();
    }

    @Override
    public int size() {
        return this.immutableSnapshot().size();
    }

    private INode<K, V> snapshot() {
        INode localRoot;
        while (!this.rdcssRoot(localRoot = this.readRoot(), localRoot.gcasRead(this), localRoot.copyToGen(new Gen(), this))) {
        }
        return localRoot;
    }

    @Override
    public ImmutableTrieMap<K, V> immutableSnapshot() {
        return new ImmutableTrieMap<K, V>(this.snapshot());
    }

    @Override
    public MutableTrieMap<K, V> mutableSnapshot() {
        return new MutableTrieMap<K, V>(this.snapshot().copyToGen(new Gen(), this));
    }

    MutableEntrySet<K, V> createEntrySet() {
        return new MutableEntrySet(this);
    }

    MutableKeySet<K> createKeySet() {
        return new MutableKeySet(this);
    }

    @Override
    MutableIterator<K, V> iterator() {
        return new MutableIterator(this);
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    INode<K, V> rdcssReadRoot(boolean abort) {
        Root r = this.root;
        if (r instanceof INode) {
            return (INode)r;
        }
        if (r instanceof RDCSS_Descriptor) {
            return this.rdcssComplete(abort);
        }
        throw new VerifyException("Unhandled root " + r);
    }

    void add(K key, V value) {
        K k = Objects.requireNonNull(key);
        this.inserthc(k, MutableTrieMap.computeHash(k), Objects.requireNonNull(value));
    }

    private static <K, V> INode<K, V> newRootNode() {
        Gen gen = new Gen();
        return new INode(gen, new CNode(gen));
    }

    private void inserthc(K key, int hc, V value) {
        if (!this.readRoot().recInsert(key, value, hc, 0, null, this)) {
            throw new VerifyException("Concurrent modification during serialization of map " + this);
        }
    }

    private @NonNull Result<V> insertifhc(K key, int hc, V value, Object cond) {
        Result res;
        while ((res = this.readRoot().recInsertIf(key, value, hc, cond, 0, null, this)) == null) {
        }
        return res;
    }

    private @NonNull Result<V> removehc(K key, Object cond, int hc) {
        Result res;
        while ((res = this.readRoot().recRemove(key, cond, hc, 0, null, this)) == null) {
        }
        return res;
    }

    private boolean casRoot(Root ov, Root nv) {
        return ROOT.compareAndSet(this, ov, nv);
    }

    private boolean rdcssRoot(INode<K, V> ov, MainNode<K, V> expectedmain, INode<K, V> nv) {
        RDCSS_Descriptor<K, V> desc = new RDCSS_Descriptor<K, V>(ov, expectedmain, nv);
        if (this.casRoot(ov, desc)) {
            this.rdcssComplete(false);
            return desc.committed;
        }
        return false;
    }

    private INode<K, V> rdcssComplete(boolean abort) {
        INode ov;
        while (true) {
            Root r;
            if ((r = this.root) instanceof INode) {
                return (INode)r;
            }
            if (!(r instanceof RDCSS_Descriptor)) {
                throw new VerifyException("Unhandled root " + r);
            }
            RDCSS_Descriptor desc = (RDCSS_Descriptor)r;
            ov = desc.old;
            MainNode exp = desc.expectedmain;
            INode nv = desc.nv;
            if (abort) {
                if (!this.casRoot(desc, ov)) continue;
                return ov;
            }
            MainNode oldmain = ov.gcasRead(this);
            if (oldmain == exp) {
                if (!this.casRoot(desc, nv)) continue;
                desc.committed = true;
                return nv;
            }
            if (this.casRoot(desc, ov)) break;
        }
        return ov;
    }

    static {
        try {
            ROOT = MethodHandles.lookup().findVarHandle(MutableTrieMap.class, "root", Root.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Root {
    }

    private static final class RDCSS_Descriptor<K, V>
    implements Root {
        final INode<K, V> old;
        final MainNode<K, V> expectedmain;
        final INode<K, V> nv;
        volatile boolean committed = false;

        RDCSS_Descriptor(INode<K, V> old, MainNode<K, V> expectedmain, INode<K, V> nv) {
            this.old = old;
            this.expectedmain = expectedmain;
            this.nv = nv;
        }
    }
}

