/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.status;

import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ReadableCounter
implements AutoCloseable {
    private final long addressOffset;
    private final long registrationId;
    private final int counterId;
    private volatile boolean isClosed = false;
    private final byte[] buffer;
    private final CountersReader countersReader;

    public ReadableCounter(CountersReader countersReader, long registrationId, int counterId) {
        int counterState = countersReader.getCounterState(counterId);
        if (counterState != 1) {
            throw new IllegalStateException("Counter not allocated: id=" + counterId + " state=" + counterState);
        }
        this.countersReader = countersReader;
        this.counterId = counterId;
        this.registrationId = registrationId;
        AtomicBuffer valuesBuffer = countersReader.valuesBuffer();
        int counterOffset = CountersReader.counterOffset((int)counterId);
        valuesBuffer.boundsCheck(counterOffset, 8);
        this.buffer = valuesBuffer.byteArray();
        this.addressOffset = valuesBuffer.addressOffset() + (long)counterOffset;
    }

    public ReadableCounter(CountersReader countersReader, int counterId) {
        this(countersReader, -1L, counterId);
    }

    public long registrationId() {
        return this.registrationId;
    }

    public int counterId() {
        return this.counterId;
    }

    public int state() {
        return this.countersReader.getCounterState(this.counterId);
    }

    public String label() {
        return this.countersReader.getCounterLabel(this.counterId);
    }

    public long get() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.buffer, this.addressOffset);
    }

    public long getWeak() {
        return UnsafeAccess.UNSAFE.getLong(this.buffer, this.addressOffset);
    }

    @Override
    public void close() {
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }
}

