/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.util;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.opendaylight.mdsal.binding.util.CheckedConsumer;
import org.opendaylight.mdsal.binding.util.CheckedFunction;
import org.opendaylight.mdsal.binding.util.Datastore;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedConsumer;
import org.opendaylight.mdsal.binding.util.InterruptibleCheckedFunction;
import org.opendaylight.mdsal.binding.util.ManagedNewTransactionRunner;
import org.opendaylight.mdsal.binding.util.ManagedTransactionChain;
import org.opendaylight.mdsal.binding.util.TypedReadTransaction;
import org.opendaylight.mdsal.binding.util.TypedReadWriteTransaction;
import org.opendaylight.mdsal.binding.util.TypedWriteTransaction;
import org.opendaylight.mdsal.common.api.OptimisticLockFailedException;
import org.opendaylight.mdsal.common.api.ReadFailedException;

class RetryingManagedNewTransactionRunnerImpl
implements ManagedNewTransactionRunner {
    private static final int DEFAULT_RETRIES = 3;
    private final int maxRetries;
    private final ManagedNewTransactionRunner delegate;
    private final Executor executor;

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate) {
        this(delegate, MoreExecutors.directExecutor(), 3);
    }

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate, int maxRetries) {
        this(delegate, MoreExecutors.directExecutor(), maxRetries);
    }

    RetryingManagedNewTransactionRunnerImpl(ManagedNewTransactionRunner delegate, Executor executor, int maxRetries) {
        this.delegate = Objects.requireNonNull(delegate, "delegate must not be null");
        this.executor = Objects.requireNonNull(executor, "executor must not be null");
        this.maxRetries = maxRetries;
    }

    @Override
    public <D extends Datastore, E extends Exception, R> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(D datastore, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E, InterruptedException {
        return this.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txFunction, this.maxRetries);
    }

    private <R, D extends Datastore, E extends Exception> R applyInterruptiblyWithNewReadOnlyTransactionAndClose(D datastore, InterruptibleCheckedFunction<TypedReadTransaction<D>, R, E> txFunction, int tries) throws E, InterruptedException {
        try {
            return this.delegate.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txFunction);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                return this.applyInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txFunction, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception, R> R applyWithNewReadOnlyTransactionAndClose(D datastore, CheckedFunction<TypedReadTransaction<D>, R, E> txFunction) throws E {
        return this.applyWithNewReadOnlyTransactionAndClose(datastore, txFunction, this.maxRetries);
    }

    private <R, D extends Datastore, E extends Exception> R applyWithNewReadOnlyTransactionAndClose(D datastore, CheckedFunction<TypedReadTransaction<D>, R, E> txFunction, int tries) throws E {
        try {
            return this.delegate.applyWithNewReadOnlyTransactionAndClose(datastore, txFunction);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                return this.applyWithNewReadOnlyTransactionAndClose(datastore, txFunction, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(D datastore, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txFunction) {
        return this.applyWithNewReadWriteTransactionAndSubmit(datastore, txFunction, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, R> FluentFuture<R> applyWithNewReadWriteTransactionAndSubmit(D datastore, InterruptibleCheckedFunction<TypedReadWriteTransaction<D>, R, E> txRunner, int tries) {
        FluentFuture<R> future = Objects.requireNonNull(this.delegate.applyWithNewReadWriteTransactionAndSubmit(datastore, txRunner), "delegate.callWithNewReadWriteTransactionAndSubmit() == null");
        return future.catchingAsync(Exception.class, exception -> {
            if (this.isRetriableException((Throwable)exception) && tries - 1 > 0) {
                return this.applyWithNewReadWriteTransactionAndSubmit(datastore, txRunner, tries - 1);
            }
            throw exception;
        }, this.executor);
    }

    @Override
    public <R> R applyWithNewTransactionChainAndClose(Function<ManagedTransactionChain, R> chainConsumer) {
        throw new UnsupportedOperationException("The retrying transaction manager doesn't support transaction chains");
    }

    @Override
    public <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(D datastore, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E, InterruptedException {
        this.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception> void callInterruptiblyWithNewReadOnlyTransactionAndClose(D datastore, InterruptibleCheckedConsumer<TypedReadTransaction<D>, E> txConsumer, int tries) throws E, InterruptedException {
        try {
            this.delegate.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txConsumer);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                this.callInterruptiblyWithNewReadOnlyTransactionAndClose(datastore, txConsumer, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(D datastore, CheckedConsumer<TypedReadTransaction<D>, E> txConsumer) throws E {
        this.callWithNewReadOnlyTransactionAndClose(datastore, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception> void callWithNewReadOnlyTransactionAndClose(D datastore, CheckedConsumer<TypedReadTransaction<D>, E> txConsumer, int tries) throws E {
        try {
            this.delegate.callWithNewReadOnlyTransactionAndClose(datastore, txConsumer);
        }
        catch (Exception e) {
            if (this.isRetriableException(e) && tries - 1 > 0) {
                this.callWithNewReadOnlyTransactionAndClose(datastore, txConsumer, tries - 1);
            }
            throw e;
        }
    }

    @Override
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewReadWriteTransactionAndSubmit(D datastore, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewReadWriteTransactionAndSubmit(datastore, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, T> FluentFuture<T> callWithNewReadWriteTransactionAndSubmit(D datastore, InterruptibleCheckedConsumer<TypedReadWriteTransaction<D>, E> txRunner, int tries) {
        return Objects.requireNonNull(this.delegate.callWithNewReadWriteTransactionAndSubmit(datastore, txRunner), "delegate.callWithNewWriteOnlyTransactionAndSubmit() == null").catchingAsync(Exception.class, exception -> {
            if (this.isRetriableException((Throwable)exception) && tries - 1 > 0) {
                return this.callWithNewReadWriteTransactionAndSubmit(datastore, txRunner, tries - 1);
            }
            throw exception;
        }, this.executor);
    }

    @Override
    public <D extends Datastore, E extends Exception> FluentFuture<? extends Object> callWithNewWriteOnlyTransactionAndSubmit(D datastore, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txConsumer) {
        return this.callWithNewWriteOnlyTransactionAndSubmit(datastore, txConsumer, this.maxRetries);
    }

    private <D extends Datastore, E extends Exception, T> FluentFuture<T> callWithNewWriteOnlyTransactionAndSubmit(D datastore, InterruptibleCheckedConsumer<TypedWriteTransaction<D>, E> txRunner, int tries) {
        return Objects.requireNonNull(this.delegate.callWithNewWriteOnlyTransactionAndSubmit(datastore, txRunner), "delegate.callWithNewWriteOnlyTransactionAndSubmit() == null").catchingAsync(OptimisticLockFailedException.class, optimisticLockFailedException -> {
            if (tries - 1 > 0) {
                return this.callWithNewWriteOnlyTransactionAndSubmit(datastore, txRunner, tries - 1);
            }
            throw optimisticLockFailedException;
        }, this.executor);
    }

    private boolean isRetriableException(Throwable throwable) {
        return throwable instanceof OptimisticLockFailedException || throwable instanceof ReadFailedException || throwable instanceof ExecutionException && this.isRetriableException(throwable.getCause());
    }
}

