/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.ActorSelection;
import akka.actor.ActorSystem;
import akka.actor.Props;
import akka.cluster.Cluster;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.io.FileBackedOutputStreamFactory;
import org.opendaylight.controller.cluster.raft.ConfigParams;
import org.opendaylight.controller.cluster.raft.ElectionTerm;
import org.opendaylight.controller.cluster.raft.PeerInfo;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftActorLeadershipTransferCohort;
import org.opendaylight.controller.cluster.raft.ReplicatedLog;
import org.opendaylight.controller.cluster.raft.SnapshotManager;
import org.opendaylight.controller.cluster.raft.VotingState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.persisted.ServerConfigurationPayload;
import org.opendaylight.controller.cluster.raft.persisted.ServerInfo;
import org.opendaylight.controller.cluster.raft.policy.RaftPolicy;
import org.slf4j.Logger;

public class RaftActorContextImpl
implements RaftActorContext {
    private static final LongSupplier JVM_MEMORY_RETRIEVER = () -> Runtime.getRuntime().maxMemory();
    private final ActorRef actor;
    private final ActorContext context;
    private final @NonNull Executor executor;
    private final String id;
    private final ElectionTerm termInformation;
    private long commitIndex;
    private long lastApplied;
    private ReplicatedLog replicatedLog;
    private final Map<String, PeerInfo> peerInfoMap = new HashMap<String, PeerInfo>();
    private final Logger log;
    private ConfigParams configParams;
    private boolean dynamicServerConfiguration = false;
    @VisibleForTesting
    private LongSupplier totalMemoryRetriever = JVM_MEMORY_RETRIEVER;
    private SnapshotManager snapshotManager;
    private final DataPersistenceProvider persistenceProvider;
    private short payloadVersion;
    private boolean votingMember = true;
    private RaftActorBehavior currentBehavior;
    private int numVotingPeers = -1;
    private Optional<Cluster> cluster;
    private final Consumer<ApplyState> applyStateConsumer;
    private final FileBackedOutputStreamFactory fileBackedOutputStreamFactory;
    private RaftActorLeadershipTransferCohort leadershipTransferCohort;

    public RaftActorContextImpl(ActorRef actor, ActorContext context, String id, @NonNull ElectionTerm termInformation, long commitIndex, long lastApplied, @NonNull Map<String, String> peerAddresses, @NonNull ConfigParams configParams, @NonNull DataPersistenceProvider persistenceProvider, @NonNull Consumer<ApplyState> applyStateConsumer, @NonNull Logger logger, @NonNull Executor executor) {
        this.actor = actor;
        this.context = context;
        this.id = id;
        this.termInformation = Objects.requireNonNull(termInformation);
        this.executor = Objects.requireNonNull(executor);
        this.commitIndex = commitIndex;
        this.lastApplied = lastApplied;
        this.configParams = Objects.requireNonNull(configParams);
        this.persistenceProvider = Objects.requireNonNull(persistenceProvider);
        this.log = Objects.requireNonNull(logger);
        this.applyStateConsumer = Objects.requireNonNull(applyStateConsumer);
        this.fileBackedOutputStreamFactory = new FileBackedOutputStreamFactory(configParams.getFileBackedStreamingThreshold(), configParams.getTempFileDirectory());
        for (Map.Entry<String, String> e : Objects.requireNonNull(peerAddresses).entrySet()) {
            this.peerInfoMap.put(e.getKey(), new PeerInfo(e.getKey(), e.getValue(), VotingState.VOTING));
        }
    }

    @VisibleForTesting
    public void setPayloadVersion(short payloadVersion) {
        this.payloadVersion = payloadVersion;
    }

    @Override
    public short getPayloadVersion() {
        return this.payloadVersion;
    }

    public void setConfigParams(ConfigParams configParams) {
        this.configParams = configParams;
    }

    @Override
    public ActorRef actorOf(Props props) {
        return this.context.actorOf(props);
    }

    @Override
    public ActorSelection actorSelection(String path) {
        return this.context.actorSelection(path);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ActorRef getActor() {
        return this.actor;
    }

    @Override
    public final Executor getExecutor() {
        return this.executor;
    }

    @Override
    public Optional<Cluster> getCluster() {
        if (this.cluster == null) {
            try {
                this.cluster = Optional.of(Cluster.get((ActorSystem)this.getActorSystem()));
            }
            catch (Exception e) {
                this.log.debug("{}: Could not obtain Cluster", (Object)this.getId(), (Object)e);
                this.cluster = Optional.empty();
            }
        }
        return this.cluster;
    }

    @Override
    public ElectionTerm getTermInformation() {
        return this.termInformation;
    }

    @Override
    public long getCommitIndex() {
        return this.commitIndex;
    }

    @Override
    public void setCommitIndex(long commitIndex) {
        this.commitIndex = commitIndex;
    }

    @Override
    public long getLastApplied() {
        return this.lastApplied;
    }

    @Override
    public void setLastApplied(long lastApplied) {
        Throwable stackTrace = this.log.isTraceEnabled() ? new Throwable() : null;
        this.log.debug("{}: Moving last applied index from {} to {}", new Object[]{this.id, this.lastApplied, lastApplied, stackTrace});
        this.lastApplied = lastApplied;
    }

    @Override
    public void setReplicatedLog(ReplicatedLog replicatedLog) {
        this.replicatedLog = replicatedLog;
    }

    @Override
    public ReplicatedLog getReplicatedLog() {
        return this.replicatedLog;
    }

    @Override
    public ActorSystem getActorSystem() {
        return this.context.system();
    }

    @Override
    public Logger getLogger() {
        return this.log;
    }

    @Override
    public Collection<String> getPeerIds() {
        return this.peerInfoMap.keySet();
    }

    @Override
    public Collection<PeerInfo> getPeers() {
        return this.peerInfoMap.values();
    }

    @Override
    public PeerInfo getPeerInfo(String peerId) {
        return this.peerInfoMap.get(peerId);
    }

    @Override
    public String getPeerAddress(String peerId) {
        String peerAddress;
        PeerInfo peerInfo = this.peerInfoMap.get(peerId);
        if (peerInfo != null) {
            peerAddress = peerInfo.getAddress();
            if (peerAddress == null) {
                peerAddress = this.configParams.getPeerAddressResolver().resolve(peerId);
                peerInfo.setAddress(peerAddress);
            }
        } else {
            peerAddress = this.configParams.getPeerAddressResolver().resolve(peerId);
        }
        return peerAddress;
    }

    @Override
    public void updatePeerIds(ServerConfigurationPayload serverConfig) {
        this.votingMember = true;
        boolean foundSelf = false;
        HashSet<String> currentPeers = new HashSet<String>(this.getPeerIds());
        for (ServerInfo server : serverConfig.getServerConfig()) {
            VotingState votingState;
            if (this.getId().equals(server.getId())) {
                foundSelf = true;
                if (server.isVoting()) continue;
                this.votingMember = false;
                continue;
            }
            VotingState votingState2 = votingState = server.isVoting() ? VotingState.VOTING : VotingState.NON_VOTING;
            if (!currentPeers.contains(server.getId())) {
                this.addToPeers(server.getId(), null, votingState);
                continue;
            }
            this.getPeerInfo(server.getId()).setVotingState(votingState);
            currentPeers.remove(server.getId());
        }
        for (String peerIdToRemove : currentPeers) {
            this.removePeer(peerIdToRemove);
        }
        if (!foundSelf) {
            this.votingMember = false;
        }
        this.log.debug("{}: Updated server config: isVoting: {}, peers: {}", new Object[]{this.id, this.votingMember, this.peerInfoMap.values()});
        this.setDynamicServerConfigurationInUse();
    }

    @Override
    public ConfigParams getConfigParams() {
        return this.configParams;
    }

    @Override
    public void addToPeers(String peerId, String address, VotingState votingState) {
        this.peerInfoMap.put(peerId, new PeerInfo(peerId, address, votingState));
        this.numVotingPeers = -1;
    }

    @Override
    public void removePeer(String name) {
        if (this.getId().equals(name)) {
            this.votingMember = false;
        } else {
            this.peerInfoMap.remove(name);
            this.numVotingPeers = -1;
        }
    }

    @Override
    public ActorSelection getPeerActorSelection(String peerId) {
        String peerAddress = this.getPeerAddress(peerId);
        if (peerAddress != null) {
            return this.actorSelection(peerAddress);
        }
        return null;
    }

    @Override
    public void setPeerAddress(String peerId, String peerAddress) {
        PeerInfo peerInfo = this.peerInfoMap.get(peerId);
        if (peerInfo != null) {
            this.log.info("Peer address for peer {} set to {}", (Object)peerId, (Object)peerAddress);
            peerInfo.setAddress(peerAddress);
        }
    }

    @Override
    public SnapshotManager getSnapshotManager() {
        if (this.snapshotManager == null) {
            this.snapshotManager = new SnapshotManager(this, this.log);
        }
        return this.snapshotManager;
    }

    @Override
    public long getTotalMemory() {
        return this.totalMemoryRetriever.getAsLong();
    }

    @Override
    public void setTotalMemoryRetriever(LongSupplier retriever) {
        this.totalMemoryRetriever = retriever == null ? JVM_MEMORY_RETRIEVER : retriever;
    }

    @Override
    public boolean hasFollowers() {
        return !this.getPeerIds().isEmpty();
    }

    @Override
    public DataPersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    @Override
    public RaftPolicy getRaftPolicy() {
        return this.configParams.getRaftPolicy();
    }

    @Override
    public boolean isDynamicServerConfigurationInUse() {
        return this.dynamicServerConfiguration;
    }

    @Override
    public void setDynamicServerConfigurationInUse() {
        this.dynamicServerConfiguration = true;
    }

    @Override
    public ServerConfigurationPayload getPeerServerInfo(boolean includeSelf) {
        if (!this.isDynamicServerConfigurationInUse()) {
            return null;
        }
        Collection<PeerInfo> peers = this.getPeers();
        ImmutableList.Builder newConfig = ImmutableList.builderWithExpectedSize((int)(peers.size() + (includeSelf ? 1 : 0)));
        for (PeerInfo peer : peers) {
            newConfig.add((Object)new ServerInfo(peer.getId(), peer.isVoting()));
        }
        if (includeSelf) {
            newConfig.add((Object)new ServerInfo(this.getId(), this.votingMember));
        }
        return new ServerConfigurationPayload((List<ServerInfo>)newConfig.build());
    }

    @Override
    public boolean isVotingMember() {
        return this.votingMember;
    }

    @Override
    public boolean anyVotingPeers() {
        if (this.numVotingPeers < 0) {
            this.numVotingPeers = 0;
            for (PeerInfo info : this.getPeers()) {
                if (!info.isVoting()) continue;
                ++this.numVotingPeers;
            }
        }
        return this.numVotingPeers > 0;
    }

    @Override
    public RaftActorBehavior getCurrentBehavior() {
        return this.currentBehavior;
    }

    void setCurrentBehavior(RaftActorBehavior behavior) {
        this.currentBehavior = Objects.requireNonNull(behavior);
    }

    @Override
    public Consumer<ApplyState> getApplyStateConsumer() {
        return this.applyStateConsumer;
    }

    @Override
    public FileBackedOutputStreamFactory getFileBackedOutputStreamFactory() {
        return this.fileBackedOutputStreamFactory;
    }

    void close() {
        if (this.currentBehavior != null) {
            try {
                this.currentBehavior.close();
            }
            catch (Exception e) {
                this.log.debug("{}: Error closing behavior {}", new Object[]{this.getId(), this.currentBehavior.state(), e});
            }
        }
    }

    @Override
    public RaftActorLeadershipTransferCohort getRaftActorLeadershipTransferCohort() {
        return this.leadershipTransferCohort;
    }

    @Override
    public void setRaftActorLeadershipTransferCohort(RaftActorLeadershipTransferCohort leadershipTransferCohort) {
        this.leadershipTransferCohort = leadershipTransferCohort;
    }
}

