/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.base.messages.ApplyState;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractLeader;
import org.opendaylight.controller.cluster.raft.behaviors.Leader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.persisted.NoopPayload;

public class PreLeader
extends AbstractLeader {
    public PreLeader(RaftActorContext context) {
        super(context, RaftState.PreLeader);
        context.getActor().tell((Object)NoopPayload.INSTANCE, context.getActor());
    }

    @Override
    public RaftActorBehavior handleMessage(ActorRef sender, Object message) {
        if (message instanceof ApplyState) {
            this.log.debug("{}: Received {} - lastApplied: {}, lastIndex: {}", new Object[]{this.logName(), message, this.context.getLastApplied(), this.context.getReplicatedLog().lastIndex()});
            if (this.context.getLastApplied() >= this.context.getReplicatedLog().lastIndex()) {
                return this.internalSwitchBehavior(new Leader(this.context, this));
            }
            return this;
        }
        return super.handleMessage(sender, message);
    }
}

