/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.messages;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.ReplicatedLogEntry;
import org.opendaylight.controller.cluster.raft.messages.AE;
import org.opendaylight.controller.cluster.raft.messages.AbstractRaftRPC;
import org.opendaylight.controller.cluster.raft.messages.Payload;
import org.opendaylight.controller.cluster.raft.persisted.SimpleReplicatedLogEntry;

public final class AppendEntries
extends AbstractRaftRPC {
    private static final long serialVersionUID = 1L;
    private final @NonNull String leaderId;
    private final long prevLogIndex;
    private final long prevLogTerm;
    private final @NonNull List<ReplicatedLogEntry> entries;
    private final long leaderCommit;
    private final long replicatedToAllIndex;
    private final short payloadVersion;
    private final short recipientRaftVersion;
    private final short leaderRaftVersion;
    private final String leaderAddress;

    AppendEntries(long term, @NonNull String leaderId, long prevLogIndex, long prevLogTerm, @NonNull List<ReplicatedLogEntry> entries, long leaderCommit, long replicatedToAllIndex, short payloadVersion, short recipientRaftVersion, short leaderRaftVersion, @Nullable String leaderAddress) {
        super(term);
        this.leaderId = Objects.requireNonNull(leaderId);
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.entries = Objects.requireNonNull(entries);
        this.leaderCommit = leaderCommit;
        this.replicatedToAllIndex = replicatedToAllIndex;
        this.payloadVersion = payloadVersion;
        this.recipientRaftVersion = recipientRaftVersion;
        this.leaderRaftVersion = leaderRaftVersion;
        this.leaderAddress = leaderAddress;
    }

    public AppendEntries(long term, @NonNull String leaderId, long prevLogIndex, long prevLogTerm, @NonNull List<ReplicatedLogEntry> entries, long leaderCommit, long replicatedToAllIndex, short payloadVersion, short recipientRaftVersion, @Nullable String leaderAddress) {
        this(term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit, replicatedToAllIndex, payloadVersion, recipientRaftVersion, 5, leaderAddress);
    }

    @VisibleForTesting
    public AppendEntries(long term, @NonNull String leaderId, long prevLogIndex, long prevLogTerm, @NonNull List<ReplicatedLogEntry> entries, long leaderCommit, long replicatedToAllIndex, short payloadVersion) {
        this(term, leaderId, prevLogIndex, prevLogTerm, entries, leaderCommit, replicatedToAllIndex, payloadVersion, 5, null);
    }

    public @NonNull String getLeaderId() {
        return this.leaderId;
    }

    public long getPrevLogIndex() {
        return this.prevLogIndex;
    }

    public long getPrevLogTerm() {
        return this.prevLogTerm;
    }

    public @NonNull List<ReplicatedLogEntry> getEntries() {
        return this.entries;
    }

    public long getLeaderCommit() {
        return this.leaderCommit;
    }

    public long getReplicatedToAllIndex() {
        return this.replicatedToAllIndex;
    }

    public short getPayloadVersion() {
        return this.payloadVersion;
    }

    public Optional<String> getLeaderAddress() {
        return Optional.ofNullable(this.leaderAddress);
    }

    public short getLeaderRaftVersion() {
        return this.leaderRaftVersion;
    }

    public String toString() {
        return "AppendEntries [leaderId=" + this.leaderId + ", prevLogIndex=" + this.prevLogIndex + ", prevLogTerm=" + this.prevLogTerm + ", leaderCommit=" + this.leaderCommit + ", replicatedToAllIndex=" + this.replicatedToAllIndex + ", payloadVersion=" + this.payloadVersion + ", recipientRaftVersion=" + this.recipientRaftVersion + ", leaderRaftVersion=" + this.leaderRaftVersion + ", leaderAddress=" + this.leaderAddress + ", entries=" + this.entries + "]";
    }

    @Override
    Object writeReplace() {
        if (this.recipientRaftVersion <= 3) {
            return new Proxy(this);
        }
        return this.recipientRaftVersion == 4 ? new ProxyV2(this) : new AE(this);
    }

    @Deprecated
    private static class Proxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private AppendEntries appendEntries;

        public Proxy() {
        }

        Proxy(AppendEntries appendEntries) {
            this.appendEntries = appendEntries;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.appendEntries.getTerm());
            out.writeObject(this.appendEntries.leaderId);
            out.writeLong(this.appendEntries.prevLogTerm);
            out.writeLong(this.appendEntries.prevLogIndex);
            out.writeLong(this.appendEntries.leaderCommit);
            out.writeLong(this.appendEntries.replicatedToAllIndex);
            out.writeShort(this.appendEntries.payloadVersion);
            out.writeInt(this.appendEntries.entries.size());
            for (ReplicatedLogEntry e : this.appendEntries.entries) {
                out.writeLong(e.getIndex());
                out.writeLong(e.getTerm());
                out.writeObject(e.getData());
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            long term = in.readLong();
            String leaderId = (String)in.readObject();
            long prevLogTerm = in.readLong();
            long prevLogIndex = in.readLong();
            long leaderCommit = in.readLong();
            long replicatedToAllIndex = in.readLong();
            short payloadVersion = in.readShort();
            int size = in.readInt();
            ImmutableList.Builder entries = ImmutableList.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                entries.add((Object)new SimpleReplicatedLogEntry(in.readLong(), in.readLong(), (Payload)in.readObject()));
            }
            this.appendEntries = new AppendEntries(term, leaderId, prevLogIndex, prevLogTerm, (List<ReplicatedLogEntry>)entries.build(), leaderCommit, replicatedToAllIndex, payloadVersion, 5, 3, null);
        }

        private Object readResolve() {
            return this.appendEntries;
        }
    }

    private static class ProxyV2
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private AppendEntries appendEntries;

        public ProxyV2() {
        }

        ProxyV2(AppendEntries appendEntries) {
            this.appendEntries = appendEntries;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeShort(this.appendEntries.leaderRaftVersion);
            out.writeLong(this.appendEntries.getTerm());
            out.writeObject(this.appendEntries.leaderId);
            out.writeLong(this.appendEntries.prevLogTerm);
            out.writeLong(this.appendEntries.prevLogIndex);
            out.writeLong(this.appendEntries.leaderCommit);
            out.writeLong(this.appendEntries.replicatedToAllIndex);
            out.writeShort(this.appendEntries.payloadVersion);
            out.writeInt(this.appendEntries.entries.size());
            for (ReplicatedLogEntry e : this.appendEntries.entries) {
                out.writeLong(e.getIndex());
                out.writeLong(e.getTerm());
                out.writeObject(e.getData());
            }
            out.writeObject(this.appendEntries.leaderAddress);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            short leaderRaftVersion = in.readShort();
            long term = in.readLong();
            String leaderId = (String)in.readObject();
            long prevLogTerm = in.readLong();
            long prevLogIndex = in.readLong();
            long leaderCommit = in.readLong();
            long replicatedToAllIndex = in.readLong();
            short payloadVersion = in.readShort();
            int size = in.readInt();
            ImmutableList.Builder entries = ImmutableList.builderWithExpectedSize((int)size);
            for (int i = 0; i < size; ++i) {
                entries.add((Object)new SimpleReplicatedLogEntry(in.readLong(), in.readLong(), (Payload)in.readObject()));
            }
            String leaderAddress = (String)in.readObject();
            this.appendEntries = new AppendEntries(term, leaderId, prevLogIndex, prevLogTerm, (List<ReplicatedLogEntry>)entries.build(), leaderCommit, replicatedToAllIndex, payloadVersion, 5, leaderRaftVersion, leaderAddress);
        }

        private Object readResolve() {
            return this.appendEntries;
        }
    }
}

