/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.CheckedValue;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.ContainerContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.spi.AbstractEffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public final class DataSchemaContextTree
extends AbstractEffectiveModelContextProvider {
    private static final LoadingCache<EffectiveModelContext, @NonNull DataSchemaContextTree> TREES = CacheBuilder.newBuilder().weakKeys().weakValues().build((CacheLoader)new CacheLoader<EffectiveModelContext, DataSchemaContextTree>(){

        public DataSchemaContextTree load(EffectiveModelContext key) {
            return new DataSchemaContextTree(key);
        }
    });
    private final @NonNull ContainerContextNode root;

    private DataSchemaContextTree(EffectiveModelContext ctx) {
        super(ctx);
        this.root = new ContainerContextNode((ContainerLike)ctx);
    }

    public static @NonNull DataSchemaContextTree from(@NonNull EffectiveModelContext ctx) {
        return (DataSchemaContextTree)((Object)TREES.getUnchecked((Object)ctx));
    }

    public @NonNull Optional<@NonNull DataSchemaContextNode<?>> findChild(@NonNull YangInstanceIdentifier path) {
        return this.root.findChild(path);
    }

    public @NonNull CheckedValue<@NonNull NodeAndStack, @NonNull IllegalArgumentException> enterPath(YangInstanceIdentifier path) {
        SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)((EffectiveModelContext)this.root.getDataSchemaNode()));
        DataSchemaContextNode node = this.root;
        for (YangInstanceIdentifier.PathArgument arg : path.getPathArguments()) {
            DataSchemaContextNode<?> child = ((DataSchemaContextNode)node).enterChild(arg, stack);
            if (child == null) {
                return CheckedValue.ofException((Exception)new IllegalArgumentException("Failed to find " + arg + " in " + node));
            }
            node = child;
        }
        return CheckedValue.ofValue((Object)new NodeAndStack(node, stack));
    }

    public @NonNull DataSchemaContextNode<?> getRoot() {
        return this.root;
    }

    public record NodeAndStack(@NonNull DataSchemaContextNode<?> node, @NonNull SchemaInferenceStack stack) {
        public NodeAndStack(@NonNull DataSchemaContextNode<?> node, @NonNull SchemaInferenceStack stack) {
            this.node = Objects.requireNonNull(node);
            this.stack = Objects.requireNonNull(stack);
        }
    }
}

