/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.io.IOException;
import org.opendaylight.yangtools.rfc7952.data.api.StreamWriterMetadataExtension;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.CompositeNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.ListEntryNodeDataWithSchema;
import org.opendaylight.yangtools.yang.data.util.MultipleEntryDataWithSchema;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ListNodeDataWithSchema
extends CompositeNodeDataWithSchema<ListSchemaNode>
implements MultipleEntryDataWithSchema<ListEntryNodeDataWithSchema> {
    public ListNodeDataWithSchema(ListSchemaNode schema) {
        super(schema);
    }

    @Override
    public void write(NormalizedNodeStreamWriter writer, StreamWriterMetadataExtension metaWriter) throws IOException {
        ListSchemaNode schema = (ListSchemaNode)this.getSchema();
        writer.nextDataSchemaNode((DataSchemaNode)schema);
        if (schema.getKeyDefinition().isEmpty()) {
            writer.startUnkeyedList(this.provideNodeIdentifier(), this.childSizeHint());
        } else if (schema.isUserOrdered()) {
            writer.startOrderedMapNode(this.provideNodeIdentifier(), this.childSizeHint());
        } else {
            writer.startMapNode(this.provideNodeIdentifier(), this.childSizeHint());
        }
        super.write(writer, metaWriter);
        writer.endNode();
    }

    @Override
    public final ListEntryNodeDataWithSchema newChildEntry() {
        ListEntryNodeDataWithSchema child = ListEntryNodeDataWithSchema.forSchema((ListSchemaNode)this.getSchema());
        this.addChild(child);
        return child;
    }
}

