/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.AbstractSimpleIdentifiable;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointChild;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContext;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointContextFactory;
import org.opendaylight.yangtools.rfc8528.data.api.MountPointIdentifier;
import org.opendaylight.yangtools.rfc8528.data.api.StreamWriterMountPointExtension;
import org.opendaylight.yangtools.rfc8528.data.api.YangLibraryConstants;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.parser.api.YangParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class MountPointData
extends AbstractSimpleIdentifiable<MountPointIdentifier> {
    private static final Logger LOG = LoggerFactory.getLogger(MountPointData.class);
    private final Map<YangLibraryConstants.ContainerName, MountPointChild> yangLib = new EnumMap<YangLibraryConstants.ContainerName, MountPointChild>(YangLibraryConstants.ContainerName.class);
    private final List<MountPointChild> children = new ArrayList<MountPointChild>();
    private final MountPointContextFactory contextFactory;
    private MountPointChild schemaMounts;

    MountPointData(MountPointIdentifier mountId, MountPointContextFactory contextFactory) {
        super((Object)mountId);
        this.contextFactory = Objects.requireNonNull(contextFactory);
    }

    public void setContainer(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangLibraryConstants.ContainerName containerName, @NonNull MountPointChild data) {
        MountPointChild prev = this.yangLib.putIfAbsent(containerName, Objects.requireNonNull(data));
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Attempted to duplicate container %s data %s with %s", (Object)containerName, (Object)prev, (Object)data);
        this.addChild(data);
    }

    public void setSchemaMounts(@NonNull MountPointChild data) {
        Preconditions.checkState((this.schemaMounts == null ? 1 : 0) != 0, (String)"Attempted to reset schema-mounts from %s to %s", (Object)this.schemaMounts, (Object)data);
        this.schemaMounts = Objects.requireNonNull(data);
        this.addChild(data);
    }

    public void addChild(@NonNull MountPointChild data) {
        this.children.add(Objects.requireNonNull(data));
    }

    void write(@NonNull NormalizedNodeStreamWriter writer) throws IOException {
        MountPointContext mountCtx;
        StreamWriterMountPointExtension mountWriter = (StreamWriterMountPointExtension)writer.getExtensions().getInstance(StreamWriterMountPointExtension.class);
        if (mountWriter == null) {
            LOG.debug("Writer {} does not support mount points, ignoring data in {}", (Object)writer, this.getIdentifier());
            return;
        }
        try {
            mountCtx = this.contextFactory.createContext(this.yangLib, this.schemaMounts);
        }
        catch (YangParserException e) {
            throw new IOException("Failed to resolve mount point " + this.getIdentifier(), e);
        }
        try (NormalizedNodeStreamWriter nestedWriter = mountWriter.startMountPoint((MountPointIdentifier)this.getIdentifier(), mountCtx);){
            for (MountPointChild child : this.children) {
                child.writeTo(nestedWriter, mountCtx);
            }
        }
    }
}

