/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.annotations.Beta;
import java.util.HashSet;
import java.util.Optional;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AugmentationNode;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

@Beta
public final class NormalizedNodeSchemaUtils {
    private NormalizedNodeSchemaUtils() {
    }

    public static Optional<CaseSchemaNode> detectCase(ChoiceSchemaNode schema, DataContainerChild child) {
        if (child instanceof AugmentationNode) {
            AugmentationNode augment = (AugmentationNode)child;
            return NormalizedNodeSchemaUtils.detectCase(schema, augment);
        }
        QName childId = child.getIdentifier().getNodeType();
        for (CaseSchemaNode choiceCaseNode : schema.getCases()) {
            if (choiceCaseNode.dataChildByName(childId) == null) continue;
            return Optional.of(choiceCaseNode);
        }
        return Optional.empty();
    }

    public static Optional<CaseSchemaNode> detectCase(ChoiceSchemaNode schema, AugmentationNode child) {
        YangInstanceIdentifier.AugmentationIdentifier childId = child.getIdentifier();
        for (CaseSchemaNode choiceCaseNode : schema.getCases()) {
            if (!NormalizedNodeSchemaUtils.belongsToCaseAugment(choiceCaseNode, childId)) continue;
            return Optional.of(choiceCaseNode);
        }
        return Optional.empty();
    }

    private static boolean belongsToCaseAugment(CaseSchemaNode caseNode, YangInstanceIdentifier.AugmentationIdentifier childToProcess) {
        for (AugmentationSchemaNode augmentationSchema : caseNode.getAvailableAugmentations()) {
            HashSet<QName> currentAugmentChildNodes = new HashSet<QName>();
            for (DataSchemaNode dataSchemaNode : augmentationSchema.getChildNodes()) {
                currentAugmentChildNodes.add(dataSchemaNode.getQName());
            }
            if (!childToProcess.getPossibleChildNames().equals(currentAugmentChildNodes)) continue;
            return true;
        }
        return false;
    }

    public static AugmentationSchemaNode findCorrespondingAugment(DataSchemaNode parent, DataSchemaNode child) {
        if (parent instanceof AugmentationTarget) {
            AugmentationTarget target = (AugmentationTarget)parent;
            if (!(parent instanceof ChoiceSchemaNode)) {
                for (AugmentationSchemaNode augmentation : target.getAvailableAugmentations()) {
                    if (augmentation.dataChildByName(child.getQName()) == null) continue;
                    return augmentation;
                }
            }
        }
        return null;
    }
}

