/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.util.AbstractStringInstanceIdentifierCodec;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class XpathStringParsingPathArgumentBuilder
implements Mutable {
    private static final CharMatcher WSP = CharMatcher.anyOf((CharSequence)" \t");
    private static final CharMatcher IDENTIFIER_FIRST_CHAR = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.is((char)'_')).precomputed();
    private static final CharMatcher IDENTIFIER = IDENTIFIER_FIRST_CHAR.or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-")).precomputed();
    private static final char SLASH = '/';
    private static final char BACKSLASH = '\\';
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final char EQUALS = '=';
    private static final char PRECONDITION_START = '[';
    private static final char PRECONDITION_END = ']';
    private static final char SQUOT = '\'';
    private static final char DQUOT = '\"';
    private final List<YangInstanceIdentifier.PathArgument> product = new ArrayList<YangInstanceIdentifier.PathArgument>();
    private final AbstractStringInstanceIdentifierCodec codec;
    private final SchemaInferenceStack stack;
    private final String data;
    private DataSchemaContextNode<?> current;
    private QNameModule lastModule;
    private int offset;

    XpathStringParsingPathArgumentBuilder(AbstractStringInstanceIdentifierCodec codec, String data) {
        this.codec = Objects.requireNonNull(codec);
        this.data = Objects.requireNonNull(data);
        this.offset = 0;
        DataSchemaContextTree tree = codec.getDataContextTree();
        this.stack = SchemaInferenceStack.of((EffectiveModelContext)tree.getEffectiveModelContext());
        this.current = tree.getRoot();
    }

    @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    YangInstanceIdentifier.PathArgument> build() {
        while (!this.allCharactersConsumed()) {
            this.product.add(this.computeNextArgument());
        }
        return ImmutableList.copyOf(this.product);
    }

    private YangInstanceIdentifier.PathArgument computeNextArgument() {
        this.checkValid('/' == this.currentChar(), "Identifier must start with '/'.", new Object[0]);
        this.skipCurrentChar();
        this.checkValid(!this.allCharactersConsumed(), "Identifier cannot end with '/'.", new Object[0]);
        QName name = this.nextQName();
        this.lastModule = name.getModule();
        if (this.allCharactersConsumed() || '/' == this.currentChar()) {
            return this.computeIdentifier(name);
        }
        this.checkValid('[' == this.currentChar(), "Last element must be identifier, predicate or '/'", new Object[0]);
        return this.computeIdentifierWithPredicate(name);
    }

    private DataSchemaContextNode<?> nextContextNode(QName name) {
        this.current = this.current.getChild(name);
        this.checkValid(this.current != null, "%s is not correct schema node identifier.", name);
        while (this.current.isMixin()) {
            this.product.add((YangInstanceIdentifier.PathArgument)this.current.getIdentifier());
            this.current = this.current.getChild(name);
        }
        this.stack.enterDataTree(name);
        return this.current;
    }

    private YangInstanceIdentifier.PathArgument computeIdentifierWithPredicate(QName name) {
        DataSchemaContextNode<?> currentNode = this.nextContextNode(name);
        this.checkValid(currentNode.isKeyedEntry(), "Entry %s does not allow specifying predicates.", name);
        ImmutableMap.Builder keyValues = ImmutableMap.builder();
        while (!this.allCharactersConsumed() && '[' == this.currentChar()) {
            QName key;
            this.skipCurrentChar();
            this.skipWhitespaces();
            if ('.' == this.currentChar()) {
                key = null;
                this.skipCurrentChar();
            } else {
                key = this.nextQName();
            }
            this.skipWhitespaces();
            this.checkCurrentAndSkip('=', "Precondition must contain '='");
            this.skipWhitespaces();
            String keyValue = this.nextQuotedValue();
            this.skipWhitespaces();
            this.checkCurrentAndSkip(']', "Precondition must ends with ']'");
            if (key == null && currentNode.isLeaf()) {
                this.checkValid(this.offset == this.data.length(), "Leaf argument must be last argument of instance identifier.", new Object[0]);
                Object value = this.codec.deserializeKeyValue(currentNode.getDataSchemaNode(), type -> this.resolveLeafref(((YangInstanceIdentifier.PathArgument)currentNode.getIdentifier()).getNodeType(), type), keyValue);
                return new YangInstanceIdentifier.NodeWithValue(name, value);
            }
            DataSchemaContextNode<?> keyNode = currentNode.getChild(key);
            this.checkValid(keyNode != null, "%s is not correct schema node identifier.", key);
            Object value = this.codec.deserializeKeyValue(keyNode.getDataSchemaNode(), type -> this.resolveLeafref(key, type), keyValue);
            keyValues.put((Object)key, value);
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)name, (Map)keyValues.build());
    }

    private @NonNull TypeDefinition<?> resolveLeafref(QName qname, LeafrefTypeDefinition type) {
        SchemaInferenceStack tmp = this.stack.copy();
        tmp.enterDataTree(qname);
        return tmp.resolveLeafref(type);
    }

    private YangInstanceIdentifier.PathArgument computeIdentifier(QName name) {
        DataSchemaContextNode<?> currentNode = this.nextContextNode(name);
        this.checkValid(!currentNode.isKeyedEntry(), "Entry %s requires key or value predicate to be present", name);
        return (YangInstanceIdentifier.PathArgument)currentNode.getIdentifier();
    }

    private QName nextQName() {
        String maybePrefix = this.nextIdentifier();
        if (!this.allCharactersConsumed() && ':' == this.currentChar()) {
            this.skipCurrentChar();
            return this.codec.createQName(maybePrefix, this.nextIdentifier());
        }
        return this.codec.createQName(this.lastModule, maybePrefix);
    }

    private boolean allCharactersConsumed() {
        return this.offset == this.data.length();
    }

    private void checkCurrentAndSkip(char expected, String errorMsg) {
        this.checkValid(expected == this.currentChar(), errorMsg, new Object[0]);
        ++this.offset;
    }

    private void checkValid(boolean condition, String errorMsg, Object ... attributes) {
        if (!condition) {
            throw this.iae(errorMsg, attributes);
        }
    }

    private @NonNull IllegalArgumentException iae(String errorMsg, Object ... attributes) {
        return new IllegalArgumentException("Could not parse Instance Identifier '%s'. Offset: %s : Reason: %s".formatted(this.data, this.offset, errorMsg.formatted(attributes)));
    }

    private String nextQuotedValue() {
        return switch (this.currentChar()) {
            case '\'' -> this.nextSingleQuotedValue();
            case '\"' -> this.nextDoubleQuotedValue();
            default -> throw this.iae("Value must be quote escaped with ''' or '\"'.", new Object[0]);
        };
    }

    private String nextSingleQuotedValue() {
        this.skipCurrentChar();
        int start = this.offset;
        int end = this.data.indexOf(39, start);
        this.checkValid(end != -1, "Closing single quote not found", new Object[0]);
        this.offset = end;
        this.skipCurrentChar();
        return this.data.substring(start, end);
    }

    private String nextDoubleQuotedValue() {
        this.skipCurrentChar();
        int maxIndex = this.data.length() - 1;
        StringBuilder sb = new StringBuilder();
        while (true) {
            int nextStart;
            int nextEnd;
            this.checkValid((nextEnd = this.data.indexOf(34, nextStart = this.offset)) != -1, "Closing double quote not found", new Object[0]);
            this.offset = nextEnd;
            int nextBackslash = this.data.indexOf(92, nextStart);
            if (nextBackslash == -1 || nextBackslash > nextEnd) {
                this.offset = nextEnd;
                this.skipCurrentChar();
                return sb.append(this.data, nextStart, nextEnd).toString();
            }
            this.checkValid(nextBackslash != maxIndex, "Incomplete escape", new Object[0]);
            sb.append(this.data, nextStart, nextBackslash);
            this.offset = nextBackslash;
            sb.append(this.unescape(this.data.charAt(nextBackslash + 1)));
            this.offset = nextBackslash + 2;
        }
    }

    private char unescape(char escape) {
        return switch (escape) {
            case 'n' -> '\n';
            case 't' -> '\t';
            case '\"' -> '\"';
            case '\\' -> '\\';
            default -> throw this.iae("Unrecognized escape", new Object[0]);
        };
    }

    private char currentChar() {
        return this.data.charAt(this.offset);
    }

    private void skipCurrentChar() {
        ++this.offset;
    }

    private void skipWhitespaces() {
        this.nextSequenceEnd(WSP);
    }

    private String nextIdentifier() {
        this.checkValid(IDENTIFIER_FIRST_CHAR.matches(this.currentChar()), "Identifier must start with character from set 'a-zA-Z_'", new Object[0]);
        int start = this.offset;
        this.nextSequenceEnd(IDENTIFIER);
        return this.data.substring(start, this.offset);
    }

    private void nextSequenceEnd(CharMatcher matcher) {
        while (!this.allCharactersConsumed() && matcher.matches(this.data.charAt(this.offset))) {
            ++this.offset;
        }
    }
}

