/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.annotations.Beta;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodecFactory;
import org.opendaylight.yangtools.yang.data.util.codec.CodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.LazyCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.NoopCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.PrecomputedCodecCache;
import org.opendaylight.yangtools.yang.data.util.codec.SharedCodecCache;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.LeafrefResolver;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
public enum JSONCodecFactorySupplier {
    RFC7951{

        @Override
        JSONCodecFactory createFactory(EffectiveModelContext context, CodecCache<JSONCodec<?>> cache) {
            return new JSONCodecFactory.RFC7951(context, cache);
        }
    }
    ,
    DRAFT_LHOTKA_NETMOD_YANG_JSON_02{

        @Override
        JSONCodecFactory createFactory(EffectiveModelContext context, CodecCache<JSONCodec<?>> cache) {
            return new JSONCodecFactory.Lhotka02(context, cache);
        }
    };

    private static final Logger LOG;
    private final LoadingCache<EffectiveModelContext, JSONCodecFactory> precomputed;
    private final LoadingCache<EffectiveModelContext, JSONCodecFactory> shared = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<EffectiveModelContext, JSONCodecFactory>(){

        public JSONCodecFactory load(EffectiveModelContext key) {
            return JSONCodecFactorySupplier.this.createFactory(key, (CodecCache<JSONCodec<?>>)new SharedCodecCache());
        }
    });

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="https://github.com/spotbugs/spotbugs/issues/1867")
    private JSONCodecFactorySupplier() {
        this.precomputed = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new EagerCacheLoader(this::createFactory));
    }

    public @NonNull JSONCodecFactory getPrecomputed(@NonNull EffectiveModelContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)((Object)((JSONCodecFactory)((Object)this.precomputed.getUnchecked((Object)context))))));
    }

    public @NonNull Optional<JSONCodecFactory> getPrecomputedIfAvailable(@NonNull EffectiveModelContext context) {
        return Optional.ofNullable((JSONCodecFactory)((Object)this.precomputed.getIfPresent((Object)context)));
    }

    public @NonNull JSONCodecFactory getShared(@NonNull EffectiveModelContext context) {
        return (JSONCodecFactory)((Object)Verify.verifyNotNull((Object)((Object)((JSONCodecFactory)((Object)this.shared.getUnchecked((Object)context))))));
    }

    public @NonNull JSONCodecFactory createLazy(@NonNull EffectiveModelContext context) {
        return this.createFactory(context, (CodecCache<JSONCodec<?>>)new LazyCodecCache());
    }

    public @NonNull JSONCodecFactory createSimple(@NonNull EffectiveModelContext context) {
        return this.createFactory(context, (CodecCache<JSONCodec<?>>)NoopCodecCache.getInstance());
    }

    abstract @NonNull JSONCodecFactory createFactory(EffectiveModelContext var1, CodecCache<JSONCodec<?>> var2);

    static {
        LOG = LoggerFactory.getLogger(JSONCodecFactorySupplier.class);
    }

    private static final class EagerCacheLoader
    extends CacheLoader<EffectiveModelContext, JSONCodecFactory> {
        private final BiFunction<EffectiveModelContext, CodecCache<JSONCodec<?>>, JSONCodecFactory> factorySupplier;

        EagerCacheLoader(BiFunction<EffectiveModelContext, CodecCache<JSONCodec<?>>, JSONCodecFactory> factorySupplier) {
            this.factorySupplier = Objects.requireNonNull(factorySupplier);
        }

        public JSONCodecFactory load(EffectiveModelContext key) {
            Stopwatch sw = Stopwatch.createStarted();
            LazyCodecCache lazyCache = new LazyCodecCache();
            JSONCodecFactory lazy = this.factorySupplier.apply(key, (CodecCache<JSONCodec<?>>)lazyCache);
            SchemaInferenceStack stack = SchemaInferenceStack.of((EffectiveModelContext)key);
            int visitedLeaves = 0;
            for (ModuleEffectiveStatement module : key.getModuleStatements().values()) {
                visitedLeaves += EagerCacheLoader.codecsForChildren(lazy, stack, module);
                stack.clear();
            }
            sw.stop();
            PrecomputedCodecCache cache = lazyCache.toPrecomputed();
            LOG.debug("{} leaf nodes resulted in {} simple and {} complex codecs in {}", new Object[]{visitedLeaves, cache.simpleSize(), cache.complexSize(), sw});
            return this.factorySupplier.apply(key, (CodecCache<JSONCodec<?>>)cache);
        }

        private static int codecsForChildren(JSONCodecFactory lazy, SchemaInferenceStack stack, DataTreeAwareEffectiveStatement<?, ?> parent) {
            int ret = 0;
            for (DataTreeEffectiveStatement child : parent.dataTreeNodes()) {
                if (child instanceof DataTreeAwareEffectiveStatement) {
                    DataTreeAwareEffectiveStatement dataTree = (DataTreeAwareEffectiveStatement)child;
                    stack.enterDataTree((QName)child.argument());
                    ret += EagerCacheLoader.codecsForChildren(lazy, stack, dataTree);
                    stack.exit();
                    continue;
                }
                if (!(child instanceof TypedDataSchemaNode)) continue;
                TypedDataSchemaNode typed = (TypedDataSchemaNode)child;
                lazy.codecFor((TypeAware)typed, (LeafrefResolver)stack);
                ++ret;
            }
            return ret;
        }
    }
}

