/*
 * Decompiled with CFR 0.152.
 */
package rpcbenchmark.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.binding.api.RpcConsumerRegistry;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchInput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchInputBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.GlobalRpcBenchOutput;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.RpcbenchPayloadService;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadBuilder;
import org.opendaylight.yang.gen.v1.rpcbench.payload.rev150702.payload.PayloadKey;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rpcbenchmark.impl.RTCClient;

public class GlobalBindingRTCClient
implements RTCClient {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalBindingRTCClient.class);
    private final RpcbenchPayloadService service;
    private final AtomicLong rpcOk = new AtomicLong(0L);
    private final AtomicLong rpcError = new AtomicLong(0L);
    private final GlobalRpcBenchInput inVal;
    private final int inSize;

    @Override
    public long getRpcOk() {
        return this.rpcOk.get();
    }

    @Override
    public long getRpcError() {
        return this.rpcError.get();
    }

    public GlobalBindingRTCClient(RpcConsumerRegistry registry, int inSize) {
        this.service = registry != null ? (RpcbenchPayloadService)registry.getRpcService(RpcbenchPayloadService.class) : null;
        this.inSize = inSize;
        ImmutableMap.Builder listVals = ImmutableMap.builderWithExpectedSize((int)inSize);
        for (int i = 0; i < inSize; ++i) {
            PayloadKey key = new PayloadKey(Integer.valueOf(i));
            listVals.put((Object)key, (Object)new PayloadBuilder().withKey(key).build());
        }
        this.inVal = new GlobalRpcBenchInputBuilder().setPayload((Map)listVals.build()).build();
    }

    @Override
    public void runTest(int iterations) {
        int ok = 0;
        int error = 0;
        for (int i = 0; i < iterations; ++i) {
            ListenableFuture output = this.service.globalRpcBench(this.inVal);
            try {
                RpcResult rpcResult = (RpcResult)output.get();
                if (!rpcResult.isSuccessful()) continue;
                Map retVal = ((GlobalRpcBenchOutput)rpcResult.getResult()).getPayload();
                if (retVal.size() == this.inSize) {
                    ++ok;
                    continue;
                }
                ++error;
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                ++error;
                LOG.error("Execution failed: ", (Throwable)e);
            }
        }
        this.rpcOk.addAndGet(ok);
        this.rpcError.addAndGet(error);
    }

    @Override
    public void close() {
    }
}

