/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.parser.api.ImportResolutionMode;

@NonNullByDefault
public final class YangParserConfiguration
implements Immutable {
    public static final YangParserConfiguration DEFAULT = YangParserConfiguration.builder().build();
    private final ImportResolutionMode importResolutionMode;
    private final boolean retainDeclarationReferences;
    private final boolean warnForUnkeyedLists;

    private YangParserConfiguration(ImportResolutionMode importResolutionMode, boolean retainDeclarationReferences, boolean warnForUnkeyedLists) {
        this.importResolutionMode = Objects.requireNonNull(importResolutionMode);
        this.retainDeclarationReferences = retainDeclarationReferences;
        this.warnForUnkeyedLists = warnForUnkeyedLists;
    }

    @Beta
    public ImportResolutionMode importResolutionMode() {
        return this.importResolutionMode;
    }

    public boolean retainDeclarationReferences() {
        return this.retainDeclarationReferences;
    }

    public boolean warnForUnkeyedLists() {
        return this.warnForUnkeyedLists;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.importResolutionMode, this.retainDeclarationReferences});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof YangParserConfiguration)) return false;
        YangParserConfiguration other = (YangParserConfiguration)obj;
        if (this.importResolutionMode != other.importResolutionMode) return false;
        if (this.retainDeclarationReferences != other.retainDeclarationReferences) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("importResolution", (Object)this.importResolutionMode).add("declarationReferences", this.retainDeclarationReferences).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements Mutable {
        private ImportResolutionMode importResolutionMode = ImportResolutionMode.DEFAULT;
        private boolean retainDeclarationReferences;
        private boolean warnForUnkeyedLists = true;

        private Builder() {
        }

        public YangParserConfiguration build() {
            return new YangParserConfiguration(this.importResolutionMode, this.retainDeclarationReferences, this.warnForUnkeyedLists);
        }

        @Beta
        public Builder importResolutionMode(ImportResolutionMode newImportResolutionMode) {
            this.importResolutionMode = Objects.requireNonNull(newImportResolutionMode);
            return this;
        }

        public Builder retainDeclarationReferences(boolean newRetainDeclarationReferences) {
            this.retainDeclarationReferences = newRetainDeclarationReferences;
            return this;
        }

        public Builder warnForUnkeyedLists(boolean newWarnForUnkeyedLists) {
            this.warnForUnkeyedLists = newWarnForUnkeyedLists;
            return this;
        }
    }
}

