/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import akka.actor.AbstractActor;
import akka.actor.ActorRef;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.controller.cluster.access.concepts.ClientIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.LocalHistoryIdentifier;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.DatastoreContext;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardStats;
import org.opendaylight.controller.cluster.datastore.ShardTransaction;
import org.opendaylight.controller.cluster.datastore.TransactionType;

class ShardTransactionActorFactory {
    private static final AtomicLong ACTOR_NAME_COUNTER = new AtomicLong();
    private final ShardDataTree dataTree;
    private final DatastoreContext datastoreContext;
    private final String txnDispatcherPath;
    private final ShardStats shardMBean;
    private final AbstractActor.ActorContext actorContext;
    private final ActorRef shardActor;
    private final String shardName;

    ShardTransactionActorFactory(ShardDataTree dataTree, DatastoreContext datastoreContext, String txnDispatcherPath, ActorRef shardActor, AbstractActor.ActorContext actorContext, ShardStats shardMBean, String shardName) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.datastoreContext = Objects.requireNonNull(datastoreContext);
        this.txnDispatcherPath = Objects.requireNonNull(txnDispatcherPath);
        this.shardMBean = Objects.requireNonNull(shardMBean);
        this.actorContext = Objects.requireNonNull(actorContext);
        this.shardActor = Objects.requireNonNull(shardActor);
        this.shardName = Objects.requireNonNull(shardName);
    }

    private String actorNameFor(TransactionIdentifier txId) {
        LocalHistoryIdentifier historyId = txId.getHistoryId();
        ClientIdentifier clientId = historyId.getClientId();
        FrontendIdentifier frontendId = clientId.getFrontendId();
        StringBuilder sb = new StringBuilder("shard-");
        sb.append(this.shardName).append('-').append(frontendId.getMemberName().getName()).append(':').append(frontendId.getClientType().getName()).append('@').append(clientId.getGeneration()).append(':');
        if (historyId.getHistoryId() != 0L) {
            sb.append(historyId.getHistoryId()).append('-');
        }
        return sb.append(txId.getTransactionId()).append('_').append(ACTOR_NAME_COUNTER.incrementAndGet()).toString();
    }

    ActorRef newShardTransaction(TransactionType type, TransactionIdentifier transactionID) {
        return this.actorContext.actorOf(ShardTransaction.props(type, switch (type) {
            case TransactionType.READ_ONLY -> this.dataTree.newReadOnlyTransaction(transactionID);
            case TransactionType.READ_WRITE, TransactionType.WRITE_ONLY -> this.dataTree.newReadWriteTransaction(transactionID);
            default -> throw new IllegalArgumentException("Unsupported transaction type " + type);
        }, this.shardActor, this.datastoreContext, this.shardMBean).withDispatcher(this.txnDispatcherPath), this.actorNameFor(transactionID));
    }
}

