/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import com.google.common.util.concurrent.FutureCallback;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.CompletionStage;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.access.concepts.TransactionIdentifier;
import org.opendaylight.controller.cluster.datastore.CompositeDataTreeCohort;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.datastore.ShardDataTreeCohort;
import org.opendaylight.yangtools.yang.common.Empty;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SimpleShardDataTreeCohort
extends ShardDataTreeCohort {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleShardDataTreeCohort.class);
    private final DataTreeModification transaction;
    private final ShardDataTree dataTree;
    private final TransactionIdentifier transactionId;
    private final CompositeDataTreeCohort userCohorts;
    private final @Nullable SortedSet<String> participatingShardNames;
    private ShardDataTreeCohort.State state = ShardDataTreeCohort.State.READY;
    private DataTreeCandidateTip candidate;
    private FutureCallback<?> callback;
    private Exception nextFailure;

    SimpleShardDataTreeCohort(ShardDataTree dataTree, DataTreeModification transaction, TransactionIdentifier transactionId, CompositeDataTreeCohort userCohorts, Optional<SortedSet<String>> participatingShardNames) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.transaction = Objects.requireNonNull(transaction);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.userCohorts = Objects.requireNonNull(userCohorts);
        this.participatingShardNames = Objects.requireNonNull(participatingShardNames).orElse(null);
    }

    SimpleShardDataTreeCohort(ShardDataTree dataTree, DataTreeModification transaction, TransactionIdentifier transactionId, Exception nextFailure) {
        this.dataTree = Objects.requireNonNull(dataTree);
        this.transaction = Objects.requireNonNull(transaction);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.userCohorts = null;
        this.participatingShardNames = null;
        this.nextFailure = Objects.requireNonNull(nextFailure);
    }

    public TransactionIdentifier getIdentifier() {
        return this.transactionId;
    }

    @Override
    DataTreeCandidateTip getCandidate() {
        return this.candidate;
    }

    @Override
    DataTreeModification getDataTreeModification() {
        return this.transaction;
    }

    @Override
    Optional<SortedSet<String>> getParticipatingShardNames() {
        return Optional.ofNullable(this.participatingShardNames);
    }

    private void checkState(ShardDataTreeCohort.State expected) {
        Preconditions.checkState((this.state == expected ? 1 : 0) != 0, (String)"State %s does not match expected state %s for %s", (Object)((Object)this.state), (Object)((Object)expected), (Object)this.getIdentifier());
    }

    @Override
    public void canCommit(FutureCallback<Empty> newCallback) {
        if (this.state == ShardDataTreeCohort.State.CAN_COMMIT_PENDING) {
            return;
        }
        this.checkState(ShardDataTreeCohort.State.READY);
        this.callback = Objects.requireNonNull(newCallback);
        this.state = ShardDataTreeCohort.State.CAN_COMMIT_PENDING;
        if (this.nextFailure == null) {
            this.dataTree.startCanCommit(this);
        } else {
            this.failedCanCommit(this.nextFailure);
        }
    }

    @Override
    public void preCommit(FutureCallback<DataTreeCandidate> newCallback) {
        this.checkState(ShardDataTreeCohort.State.CAN_COMMIT_COMPLETE);
        this.callback = Objects.requireNonNull(newCallback);
        this.state = ShardDataTreeCohort.State.PRE_COMMIT_PENDING;
        if (this.nextFailure == null) {
            this.dataTree.startPreCommit(this);
        } else {
            this.failedPreCommit(this.nextFailure);
        }
    }

    @Override
    public void abort(FutureCallback<Empty> abortCallback) {
        if (!this.dataTree.startAbort(this)) {
            abortCallback.onSuccess((Object)Empty.value());
            return;
        }
        this.candidate = null;
        this.state = ShardDataTreeCohort.State.ABORTED;
        Optional<CompletionStage<?>> maybeAborts = this.userCohorts.abort();
        if (!maybeAborts.isPresent()) {
            abortCallback.onSuccess((Object)Empty.value());
            return;
        }
        maybeAborts.orElseThrow().whenComplete((noop, failure) -> {
            if (failure != null) {
                abortCallback.onFailure(failure);
            } else {
                abortCallback.onSuccess((Object)Empty.value());
            }
        });
    }

    @Override
    public void commit(FutureCallback<UnsignedLong> newCallback) {
        this.checkState(ShardDataTreeCohort.State.PRE_COMMIT_COMPLETE);
        this.callback = Objects.requireNonNull(newCallback);
        this.state = ShardDataTreeCohort.State.COMMIT_PENDING;
        if (this.nextFailure == null) {
            this.dataTree.startCommit(this, (DataTreeCandidate)this.candidate);
        } else {
            this.failedCommit(this.nextFailure);
        }
    }

    private <T> FutureCallback<T> switchState(ShardDataTreeCohort.State newState) {
        FutureCallback<?> ret = this.callback;
        this.callback = null;
        LOG.debug("Transaction {} changing state from {} to {}", new Object[]{this.transactionId, this.state, newState});
        this.state = newState;
        return ret;
    }

    void setNewCandidate(DataTreeCandidateTip dataTreeCandidate) {
        this.checkState(ShardDataTreeCohort.State.PRE_COMMIT_COMPLETE);
        this.candidate = (DataTreeCandidateTip)Verify.verifyNotNull((Object)dataTreeCandidate);
    }

    void successfulCanCommit() {
        this.switchState(ShardDataTreeCohort.State.CAN_COMMIT_COMPLETE).onSuccess((Object)Empty.value());
    }

    void failedCanCommit(Exception cause) {
        this.switchState(ShardDataTreeCohort.State.FAILED).onFailure((Throwable)cause);
    }

    void userPreCommit(DataTreeCandidate dataTreeCandidate, FutureCallback<Empty> futureCallback) {
        this.userCohorts.reset();
        Optional<CompletionStage<Empty>> maybeCanCommitFuture = this.userCohorts.canCommit(dataTreeCandidate);
        if (!maybeCanCommitFuture.isPresent()) {
            this.doUserPreCommit(futureCallback);
            return;
        }
        maybeCanCommitFuture.orElseThrow().whenComplete((noop, failure) -> {
            if (failure != null) {
                futureCallback.onFailure(failure);
            } else {
                this.doUserPreCommit(futureCallback);
            }
        });
    }

    private void doUserPreCommit(FutureCallback<Empty> futureCallback) {
        Optional<CompletionStage<Empty>> maybePreCommitFuture = this.userCohorts.preCommit();
        if (!maybePreCommitFuture.isPresent()) {
            futureCallback.onSuccess((Object)Empty.value());
            return;
        }
        maybePreCommitFuture.orElseThrow().whenComplete((noop, failure) -> {
            if (failure != null) {
                futureCallback.onFailure(failure);
            } else {
                futureCallback.onSuccess((Object)Empty.value());
            }
        });
    }

    void successfulPreCommit(DataTreeCandidateTip dataTreeCandidate) {
        LOG.trace("Transaction {} prepared candidate {}", (Object)this.transaction, (Object)dataTreeCandidate);
        this.candidate = (DataTreeCandidateTip)Verify.verifyNotNull((Object)dataTreeCandidate);
        this.switchState(ShardDataTreeCohort.State.PRE_COMMIT_COMPLETE).onSuccess((Object)dataTreeCandidate);
    }

    void failedPreCommit(Throwable cause) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Transaction {} failed to prepare", (Object)this.transaction, (Object)cause);
        } else {
            LOG.error("Transaction {} failed to prepare", (Object)this.transactionId, (Object)cause);
        }
        this.userCohorts.abort();
        this.switchState(ShardDataTreeCohort.State.FAILED).onFailure(cause);
    }

    void successfulCommit(UnsignedLong journalIndex, Runnable onComplete) {
        Optional<CompletionStage<Empty>> maybeCommitFuture = this.userCohorts.commit();
        if (!maybeCommitFuture.isPresent()) {
            this.finishSuccessfulCommit(journalIndex, onComplete);
            return;
        }
        maybeCommitFuture.orElseThrow().whenComplete((noop, failure) -> {
            if (failure != null) {
                LOG.error("User cohorts failed to commit", failure);
            }
            this.finishSuccessfulCommit(journalIndex, onComplete);
        });
    }

    private void finishSuccessfulCommit(UnsignedLong journalIndex, Runnable onComplete) {
        this.switchState(ShardDataTreeCohort.State.COMMITTED).onSuccess((Object)journalIndex);
        onComplete.run();
    }

    void failedCommit(Exception cause) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Transaction {} failed to commit", (Object)this.transaction, (Object)cause);
        } else {
            LOG.error("Transaction failed to commit", (Throwable)cause);
        }
        this.userCohorts.abort();
        this.switchState(ShardDataTreeCohort.State.FAILED).onFailure((Throwable)cause);
    }

    @Override
    public ShardDataTreeCohort.State getState() {
        return this.state;
    }

    void reportFailure(Exception cause) {
        if (this.nextFailure == null) {
            this.nextFailure = Objects.requireNonNull(cause);
        } else {
            LOG.debug("Transaction {} already has a set failure, not updating it", (Object)this.transactionId, (Object)cause);
        }
    }

    @Override
    public boolean isFailed() {
        return this.state == ShardDataTreeCohort.State.FAILED || this.nextFailure != null;
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return super.addToStringAttributes(toStringHelper).add("nextFailure", (Object)this.nextFailure);
    }
}

