/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.controller.cluster.datastore.persisted.AbstractDataTreeCandidateNode;
import org.opendaylight.controller.cluster.datastore.persisted.DeletedDataTreeCandidateNode;
import org.opendaylight.controller.cluster.datastore.persisted.ModifiedDataTreeCandidateNode;
import org.opendaylight.controller.cluster.datastore.persisted.PayloadVersion;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.ReusableStreamReceiver;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataInput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeDataOutput;
import org.opendaylight.yangtools.yang.data.codec.binfmt.NormalizedNodeStreamVersion;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.tree.api.ModificationType;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.tree.spi.DataTreeCandidates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidateInputOutput {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidateInputOutput.class);
    private static final byte DELETE = 0;
    private static final byte SUBTREE_MODIFIED = 1;
    private static final byte UNMODIFIED = 2;
    private static final byte WRITE = 3;
    private static final byte APPEARED = 4;
    private static final byte DISAPPEARED = 5;

    private DataTreeCandidateInputOutput() {
        throw new UnsupportedOperationException();
    }

    private static DataTreeCandidateNode readModifiedNode(ModificationType type, NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        YangInstanceIdentifier.PathArgument identifier = in.readPathArgument();
        Collection<DataTreeCandidateNode> children = DataTreeCandidateInputOutput.readChildren(in, receiver);
        if (children.isEmpty()) {
            LOG.debug("Modified node {} does not have any children, not instantiating it", (Object)identifier);
            return null;
        }
        return ModifiedDataTreeCandidateNode.create(identifier, type, children);
    }

    private static Collection<DataTreeCandidateNode> readChildren(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        int size = in.readInt();
        if (size == 0) {
            return ImmutableList.of();
        }
        ArrayList<DataTreeCandidateNode> ret = new ArrayList<DataTreeCandidateNode>(size);
        for (int i = 0; i < size; ++i) {
            DataTreeCandidateNode child = DataTreeCandidateInputOutput.readNode(in, receiver);
            if (child == null) continue;
            ret.add(child);
        }
        return ret;
    }

    private static DataTreeCandidateNode readNode(NormalizedNodeDataInput in, ReusableStreamReceiver receiver) throws IOException {
        byte type = in.readByte();
        return switch (type) {
            case 4 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.APPEARED, in, receiver);
            case 0 -> DeletedDataTreeCandidateNode.create(in.readPathArgument());
            case 5 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.DISAPPEARED, in, receiver);
            case 1 -> DataTreeCandidateInputOutput.readModifiedNode(ModificationType.SUBTREE_MODIFIED, in, receiver);
            case 2 -> null;
            case 3 -> DataTreeCandidateNodes.written((NormalizedNode)in.readNormalizedNode(receiver));
            default -> throw new IllegalArgumentException("Unhandled node type " + type);
        };
    }

    public static DataTreeCandidateWithVersion readDataTreeCandidate(DataInput in, ReusableStreamReceiver receiver) throws IOException {
        NormalizedNodeDataInput reader = NormalizedNodeDataInput.newDataInput((DataInput)in);
        YangInstanceIdentifier rootPath = reader.readYangInstanceIdentifier();
        byte type = reader.readByte();
        DataTreeCandidateNode rootNode = switch (type) {
            case 4 -> ModifiedDataTreeCandidateNode.create(ModificationType.APPEARED, DataTreeCandidateInputOutput.readChildren(reader, receiver));
            case 0 -> DeletedDataTreeCandidateNode.create();
            case 5 -> ModifiedDataTreeCandidateNode.create(ModificationType.DISAPPEARED, DataTreeCandidateInputOutput.readChildren(reader, receiver));
            case 1 -> ModifiedDataTreeCandidateNode.create(ModificationType.SUBTREE_MODIFIED, DataTreeCandidateInputOutput.readChildren(reader, receiver));
            case 3 -> DataTreeCandidateNodes.written((NormalizedNode)reader.readNormalizedNode(receiver));
            case 2 -> AbstractDataTreeCandidateNode.createUnmodified();
            default -> throw new IllegalArgumentException("Unhandled node type " + type);
        };
        return new DataTreeCandidateWithVersion(DataTreeCandidates.newDataTreeCandidate((YangInstanceIdentifier)rootPath, (DataTreeCandidateNode)rootNode), reader.getVersion());
    }

    private static void writeChildren(NormalizedNodeDataOutput out, Collection<DataTreeCandidateNode> children) throws IOException {
        out.writeInt(children.size());
        for (DataTreeCandidateNode child : children) {
            DataTreeCandidateInputOutput.writeNode(out, child);
        }
    }

    private static void writeNode(NormalizedNodeDataOutput out, DataTreeCandidateNode node) throws IOException {
        switch (node.getModificationType()) {
            case APPEARED: {
                out.writeByte(4);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case DELETE: {
                out.writeByte(0);
                out.writePathArgument(node.getIdentifier());
                break;
            }
            case DISAPPEARED: {
                out.writeByte(5);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case SUBTREE_MODIFIED: {
                out.writeByte(1);
                out.writePathArgument(node.getIdentifier());
                DataTreeCandidateInputOutput.writeChildren(out, node.getChildNodes());
                break;
            }
            case WRITE: {
                out.writeByte(3);
                out.writeNormalizedNode((NormalizedNode)node.getDataAfter().orElseThrow());
                break;
            }
            case UNMODIFIED: {
                out.writeByte(2);
                break;
            }
            default: {
                DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    public static void writeDataTreeCandidate(DataOutput out, PayloadVersion version, DataTreeCandidate candidate) throws IOException {
        try (NormalizedNodeDataOutput writer = version.getStreamVersion().newDataOutput(out);){
            writer.writeYangInstanceIdentifier(candidate.getRootPath());
            DataTreeCandidateNode node = candidate.getRootNode();
            switch (node.getModificationType()) {
                case APPEARED: {
                    writer.writeByte(4);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case DELETE: {
                    writer.writeByte(0);
                    return;
                }
                case DISAPPEARED: {
                    writer.writeByte(5);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case SUBTREE_MODIFIED: {
                    writer.writeByte(1);
                    DataTreeCandidateInputOutput.writeChildren(writer, node.getChildNodes());
                    return;
                }
                case UNMODIFIED: {
                    writer.writeByte(2);
                    return;
                }
                case WRITE: {
                    writer.writeByte(3);
                    writer.writeNormalizedNode((NormalizedNode)node.getDataAfter().orElseThrow());
                    return;
                }
                default: {
                    DataTreeCandidateInputOutput.throwUnhandledNodeType(node);
                    return;
                }
            }
        }
    }

    public static void writeDataTreeCandidate(DataOutput out, DataTreeCandidate candidate) throws IOException {
        DataTreeCandidateInputOutput.writeDataTreeCandidate(out, PayloadVersion.current(), candidate);
    }

    private static void throwUnhandledNodeType(DataTreeCandidateNode node) {
        throw new IllegalArgumentException("Unhandled node type " + node.getModificationType());
    }

    @NonNullByDefault
    public static final class DataTreeCandidateWithVersion
    implements Immutable {
        private final DataTreeCandidate candidate;
        private final NormalizedNodeStreamVersion version;

        public DataTreeCandidateWithVersion(DataTreeCandidate candidate, NormalizedNodeStreamVersion version) {
            this.candidate = Objects.requireNonNull(candidate);
            this.version = Objects.requireNonNull(version);
        }

        public DataTreeCandidate getCandidate() {
            return this.candidate;
        }

        public NormalizedNodeStreamVersion getVersion() {
            return this.version;
        }
    }
}

