/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.datastore.persisted.DS;
import org.opendaylight.controller.cluster.datastore.persisted.DSS;
import org.opendaylight.controller.cluster.datastore.persisted.ShardManagerSnapshot;
import org.opendaylight.controller.cluster.raft.persisted.Snapshot;

public final class DatastoreSnapshot
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final @NonNull String type;
    private final ShardManagerSnapshot shardManagerSnapshot;
    private final @NonNull ImmutableList<ShardSnapshot> shardSnapshots;

    public DatastoreSnapshot(@NonNull String type, @Nullable ShardManagerSnapshot shardManagerSnapshot, @NonNull List<ShardSnapshot> shardSnapshots) {
        this.type = Objects.requireNonNull(type);
        this.shardManagerSnapshot = shardManagerSnapshot;
        this.shardSnapshots = ImmutableList.copyOf(shardSnapshots);
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable ShardManagerSnapshot getShardManagerSnapshot() {
        return this.shardManagerSnapshot;
    }

    public @NonNull List<ShardSnapshot> getShardSnapshots() {
        return this.shardSnapshots;
    }

    private Object writeReplace() {
        return new DS(this);
    }

    public static final class ShardSnapshot
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final @NonNull String name;
        private final @NonNull Snapshot snapshot;

        public ShardSnapshot(@NonNull String name, @NonNull Snapshot snapshot) {
            this.name = Objects.requireNonNull(name);
            this.snapshot = Objects.requireNonNull(snapshot);
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull Snapshot getSnapshot() {
            return this.snapshot;
        }

        private Object writeReplace() {
            return new DSS(this);
        }

        private static final class Proxy
        implements SerialForm {
            private static final long serialVersionUID = 1L;
            private ShardSnapshot shardSnapshot;

            @Override
            public ShardSnapshot shardSnapshot() {
                return this.shardSnapshot;
            }

            @Override
            public void resolveTo(String name, Snapshot snapshot) {
                this.shardSnapshot = new ShardSnapshot(name, snapshot);
            }

            @Override
            public Object readResolve() {
                return Verify.verifyNotNull((Object)this.shardSnapshot);
            }
        }

        static interface SerialForm
        extends Externalizable {
            public ShardSnapshot shardSnapshot();

            public Object readResolve();

            public void resolveTo(String var1, Snapshot var2);

            @Override
            default public void writeExternal(ObjectOutput out) throws IOException {
                ShardSnapshot shardSnapshot = this.shardSnapshot();
                out.writeObject(shardSnapshot.name);
                out.writeObject(shardSnapshot.snapshot);
            }

            @Override
            default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
                this.resolveTo((String)in.readObject(), (Snapshot)in.readObject());
            }
        }
    }

    private static final class Proxy
    implements SerialForm {
        private static final long serialVersionUID = 1L;
        private DatastoreSnapshot datastoreSnapshot;

        @Override
        public DatastoreSnapshot datastoreSnapshot() {
            return this.datastoreSnapshot;
        }

        @Override
        public void resolveTo(DatastoreSnapshot newDatastoreSnapshot) {
            this.datastoreSnapshot = Objects.requireNonNull(newDatastoreSnapshot);
        }

        @Override
        public Object readResolve() {
            return Verify.verifyNotNull((Object)this.datastoreSnapshot);
        }
    }

    static interface SerialForm
    extends Externalizable {
        public DatastoreSnapshot datastoreSnapshot();

        public Object readResolve();

        public void resolveTo(@NonNull DatastoreSnapshot var1);

        @Override
        default public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            String type = (String)in.readObject();
            ShardManagerSnapshot snapshot = (ShardManagerSnapshot)in.readObject();
            int size = in.readInt();
            ArrayList<ShardSnapshot> localShardSnapshots = new ArrayList<ShardSnapshot>(size);
            for (int i = 0; i < size; ++i) {
                localShardSnapshots.add((ShardSnapshot)in.readObject());
            }
            this.resolveTo(new DatastoreSnapshot(type, snapshot, localShardSnapshots));
        }

        @Override
        default public void writeExternal(ObjectOutput out) throws IOException {
            DatastoreSnapshot datastoreSnapshot = this.datastoreSnapshot();
            out.writeObject(datastoreSnapshot.type);
            out.writeObject(datastoreSnapshot.shardManagerSnapshot);
            out.writeInt(datastoreSnapshot.shardSnapshots.size());
            for (ShardSnapshot shardSnapshot : datastoreSnapshot.shardSnapshots) {
                out.writeObject(shardSnapshot);
            }
        }
    }
}

