/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.persisted;

import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.controller.cluster.datastore.utils.ImmutableUnsignedLongSet;
import org.opendaylight.controller.cluster.datastore.utils.UnsignedLongBitmap;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.concepts.WritableObjects;

public final class FrontendHistoryMetadata
implements WritableObject {
    private final @NonNull ImmutableUnsignedLongSet purgedTransactions;
    private final @NonNull UnsignedLongBitmap closedTransactions;
    private final long historyId;
    private final long cookie;
    private final boolean closed;

    public FrontendHistoryMetadata(long historyId, long cookie, boolean closed, UnsignedLongBitmap closedTransactions, ImmutableUnsignedLongSet purgedTransactions) {
        this.historyId = historyId;
        this.cookie = cookie;
        this.closed = closed;
        this.closedTransactions = Objects.requireNonNull(closedTransactions);
        this.purgedTransactions = Objects.requireNonNull(purgedTransactions);
    }

    public long getHistoryId() {
        return this.historyId;
    }

    public long getCookie() {
        return this.cookie;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public UnsignedLongBitmap getClosedTransactions() {
        return this.closedTransactions;
    }

    public ImmutableUnsignedLongSet getPurgedTransactions() {
        return this.purgedTransactions;
    }

    public void writeTo(DataOutput out) throws IOException {
        WritableObjects.writeLongs((DataOutput)out, (long)this.historyId, (long)this.cookie);
        out.writeBoolean(this.closed);
        int closedSize = this.closedTransactions.size();
        int purgedSize = this.purgedTransactions.rangeSize();
        WritableObjects.writeLongs((DataOutput)out, (long)closedSize, (long)purgedSize);
        this.closedTransactions.writeEntriesTo(out, closedSize);
        this.purgedTransactions.writeRangesTo(out, purgedSize);
    }

    public static FrontendHistoryMetadata readFrom(DataInput in) throws IOException {
        byte firstHdr = WritableObjects.readLongHeader((DataInput)in);
        long historyId = WritableObjects.readFirstLong((DataInput)in, (byte)firstHdr);
        long cookie = WritableObjects.readSecondLong((DataInput)in, (byte)firstHdr);
        boolean closed = in.readBoolean();
        byte secondHdr = WritableObjects.readLongHeader((DataInput)in);
        int csize = FrontendHistoryMetadata.verifySize(WritableObjects.readFirstLong((DataInput)in, (byte)secondHdr));
        int psize = FrontendHistoryMetadata.verifySize(WritableObjects.readSecondLong((DataInput)in, (byte)secondHdr));
        return new FrontendHistoryMetadata(historyId, cookie, closed, UnsignedLongBitmap.readFrom(in, csize), ImmutableUnsignedLongSet.readFrom(in, psize));
    }

    public String toString() {
        return MoreObjects.toStringHelper(FrontendHistoryMetadata.class).add("historyId", this.historyId).add("cookie", this.cookie).add("closed", this.closed).add("closedTransactions", (Object)this.closedTransactions).add("purgedTransactions", (Object)this.purgedTransactions).toString();
    }

    private static int verifySize(long size) throws IOException {
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IOException("Invalid size " + size);
        }
        return (int)size;
    }
}

