/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.parser.api.ImportResolutionMode;
import org.opendaylight.yangtools.yang.parser.api.YangParser;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.api.YangParserFactory;
import org.opendaylight.yangtools.yang.parser.impl.DefaultReactors;
import org.opendaylight.yangtools.yang.parser.impl.DefaultYangParser;
import org.opendaylight.yangtools.yang.parser.stmt.reactor.CrossSourceStatementReactor;
import org.opendaylight.yangtools.yang.xpath.api.YangXPathParserFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.RequireServiceComponentRuntime;

@Singleton
@Beta
@Component
@RequireServiceComponentRuntime
public final class DefaultYangParserFactory
implements YangParserFactory {
    private static final List<ImportResolutionMode> SUPPORTED_MODES = List.of(ImportResolutionMode.DEFAULT);
    private final ConcurrentMap<YangParserConfiguration, CrossSourceStatementReactor> reactors = new ConcurrentHashMap<YangParserConfiguration, CrossSourceStatementReactor>(2);
    private final Function<YangParserConfiguration, CrossSourceStatementReactor> reactorFactory;

    public DefaultYangParserFactory() {
        this.reactorFactory = config -> DefaultReactors.defaultReactorBuilder(config).build();
        this.reactorFactory.apply(YangParserConfiguration.DEFAULT);
    }

    @Inject
    @Activate
    public DefaultYangParserFactory(@Reference YangXPathParserFactory xpathFactory) {
        this.reactorFactory = config -> DefaultReactors.defaultReactorBuilder(xpathFactory, config).build();
    }

    public Collection<ImportResolutionMode> supportedImportResolutionModes() {
        return SUPPORTED_MODES;
    }

    public @NonNull YangParser createParser(YangParserConfiguration configuration) {
        ImportResolutionMode importMode = configuration.importResolutionMode();
        Preconditions.checkArgument((boolean)SUPPORTED_MODES.contains(importMode), (String)"Unsupported import resolution mode %s", (Object)importMode);
        return new DefaultYangParser(this.reactors.computeIfAbsent(configuration, this.reactorFactory).newBuild());
    }
}

