/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.repo;

import com.google.common.base.Function;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Cleaner;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.repo.api.EffectiveModelContextFactory;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaContextFactoryConfiguration;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaRepository;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangIRSchemaSource;
import org.opendaylight.yangtools.yang.parser.repo.AssembleSources;
import org.opendaylight.yangtools.yang.parser.repo.SharedSchemaRepository;
import org.opendaylight.yangtools.yang.parser.repo.SourceIdMismatchDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SharedEffectiveModelContextFactory
implements EffectiveModelContextFactory {
    private static final Logger LOG = LoggerFactory.getLogger(SharedEffectiveModelContextFactory.class);
    private static final Cleaner CLEANER = Cleaner.create();
    private final ConcurrentMap<Set<SourceIdentifier>, CacheEntry> cache = new ConcurrentHashMap<Set<SourceIdentifier>, CacheEntry>();
    private final AssembleSources assembleSources;
    private final SchemaRepository repository;

    SharedEffectiveModelContextFactory(@NonNull SharedSchemaRepository repository, @NonNull SchemaContextFactoryConfiguration config) {
        this.repository = (SchemaRepository)Objects.requireNonNull(repository);
        this.assembleSources = new AssembleSources(repository.factory(), config);
    }

    public @NonNull ListenableFuture<EffectiveModelContext> createEffectiveModelContext(@NonNull Collection<SourceIdentifier> requiredSources) {
        return this.createEffectiveModel((Set<SourceIdentifier>)SharedEffectiveModelContextFactory.dedupSources(requiredSources));
    }

    @NonNull ListenableFuture<EffectiveModelContext> createEffectiveModel(Set<SourceIdentifier> sources) {
        CacheEntry existing = (CacheEntry)this.cache.get(sources);
        return existing != null ? this.acquireModel(sources, existing) : this.computeModel(sources);
    }

    private @NonNull ListenableFuture<EffectiveModelContext> acquireModel(Set<SourceIdentifier> sources, @NonNull CacheEntry entry) {
        ListenableFuture<EffectiveModelContext> existing = entry.future();
        if (existing != null) {
            return existing;
        }
        this.cache.remove(sources, entry);
        return this.computeModel(sources);
    }

    private @NonNull ListenableFuture<EffectiveModelContext> computeModel(Set<SourceIdentifier> sources) {
        CacheEntry prevEntry;
        CacheEntry ourEntry = new CacheEntry();
        while ((prevEntry = this.cache.putIfAbsent(sources, ourEntry)) != null) {
            ListenableFuture<EffectiveModelContext> existing = prevEntry.future();
            if (existing != null) {
                return existing;
            }
            this.cache.remove(sources, prevEntry);
        }
        SettableFuture<EffectiveModelContext> result = ourEntry.getFuture();
        this.resolveEntry(sources, ourEntry);
        return result;
    }

    private void resolveEntry(final Set<SourceIdentifier> sources, final CacheEntry entry) {
        LOG.debug("Starting assembly of {} sources", (Object)sources.size());
        final Stopwatch sw = Stopwatch.createStarted();
        ListenableFuture sf = Futures.allAsList((Iterable)Collections2.transform(sources, identifier -> this.repository.getSchemaSource(identifier, YangIRSchemaSource.class)));
        sf = Futures.transform((ListenableFuture)sf, (Function)new SourceIdMismatchDetector(sources), (Executor)MoreExecutors.directExecutor());
        ListenableFuture cf = Futures.transformAsync((ListenableFuture)sf, (AsyncFunction)this.assembleSources, (Executor)MoreExecutors.directExecutor());
        Futures.addCallback((ListenableFuture)cf, (FutureCallback)new FutureCallback<EffectiveModelContext>(){

            public void onSuccess(EffectiveModelContext result) {
                LOG.debug("Finished assembly of {} sources in {}", (Object)sources.size(), (Object)sw);
                Stopwatch residence = Stopwatch.createStarted();
                CLEANER.register(result, () -> {
                    LOG.debug("Removing entry after {}", (Object)residence);
                    SharedEffectiveModelContextFactory.this.cache.remove(sources, entry);
                });
                entry.resolve(result);
            }

            public void onFailure(Throwable cause) {
                LOG.debug("Failed assembly of {} in {}", new Object[]{sources, sw, cause});
                entry.getFuture().setException(cause);
                SharedEffectiveModelContextFactory.this.cache.remove(sources, entry);
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static ImmutableSet<SourceIdentifier> dedupSources(Collection<SourceIdentifier> sources) {
        ImmutableSet result = ImmutableSet.copyOf(sources);
        if (result.size() != sources.size()) {
            LOG.warn("Duplicate sources requested for schema context, removed duplicate sources: {}", (Object)Collections2.filter((Collection)result, input -> Iterables.frequency((Iterable)sources, (Object)input) > 1));
        }
        return result;
    }

    private static final class CacheEntry {
        private static final java.util.function.Function<EffectiveModelContext, Reference<EffectiveModelContext>> REF;
        private static final VarHandle STATE;
        private volatile Object state = SettableFuture.create();

        private CacheEntry() {
        }

        @Nullable ListenableFuture<EffectiveModelContext> future() {
            Object local = STATE.getAcquire(this);
            if (local instanceof SettableFuture) {
                return (SettableFuture)local;
            }
            Verify.verify((boolean)(local instanceof Reference), (String)"Unexpected state %s", (Object)local);
            EffectiveModelContext model = (EffectiveModelContext)((Reference)local).get();
            return model == null ? null : Futures.immediateFuture((Object)model);
        }

        @NonNull SettableFuture<EffectiveModelContext> getFuture() {
            Object local = STATE.getAcquire(this);
            Verify.verify((boolean)(local instanceof SettableFuture), (String)"Unexpected state %s", (Object)local);
            return (SettableFuture)local;
        }

        void resolve(EffectiveModelContext context) {
            SettableFuture<EffectiveModelContext> future = this.getFuture();
            Object witness = STATE.compareAndExchangeRelease(this, future, REF.apply(context));
            Verify.verify((witness == future ? 1 : 0) != 0, (String)"Unexpected witness %s", (Object)witness);
            future.set((Object)context);
        }

        static {
            String prop;
            try {
                STATE = MethodHandles.lookup().findVarHandle(CacheEntry.class, "state", Object.class);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new ExceptionInInitializerError(e);
            }
            REF = switch (prop = System.getProperty("org.opendaylight.yangtools.yang.parser.repo.shared-refs", "weak")) {
                case "soft" -> SoftReference::new;
                case "weak" -> WeakReference::new;
                default -> {
                    LOG.warn("Invalid shared-refs \"{}\", defaulting to weak references", (Object)prop);
                    prop = "weak";
                    yield WeakReference::new;
                }
            };
            LOG.info("Using {} references", (Object)prop);
        }
    }
}

