/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.reports;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;

public final class LossReportReader {
    public static final String LOSS_REPORT_CSV_HEADER = "#OBSERVATION_COUNT,TOTAL_BYTES_LOST,FIRST_OBSERVATION,LAST_OBSERVATION,SESSION_ID,STREAM_ID,CHANNEL,SOURCE";

    public static EntryConsumer defaultEntryConsumer(PrintStream out) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
        return (observationCount, totalBytesLost, firstObservationTimestamp, lastObservationTimestamp, sessionId, streamId, channel, source) -> out.format("%d,%d,%s,%s,%d,%d,%s,%s%n", observationCount, totalBytesLost, dateFormat.format(new Date(firstObservationTimestamp)), dateFormat.format(new Date(lastObservationTimestamp)), sessionId, streamId, channel, source);
    }

    public static int read(AtomicBuffer buffer, EntryConsumer entryConsumer) {
        long observationCount;
        int recordLength;
        int capacity = buffer.capacity();
        int recordsRead = 0;
        for (int offset = 0; offset < capacity && (observationCount = buffer.getLongVolatile(offset + 0)) > 0L; offset += BitUtil.align((int)recordLength, (int)64)) {
            ++recordsRead;
            String channel = buffer.getStringAscii(offset + 40);
            String source = buffer.getStringAscii(offset + 40 + BitUtil.align((int)(4 + channel.length()), (int)4));
            entryConsumer.accept(observationCount, buffer.getLongVolatile(offset + 8), buffer.getLong(offset + 16), buffer.getLongVolatile(offset + 24), buffer.getInt(offset + 32), buffer.getInt(offset + 36), channel, source);
            recordLength = 40 + BitUtil.align((int)(4 + channel.length()), (int)4) + 4 + source.length();
        }
        return recordsRead;
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(long var1, long var3, long var5, long var7, int var9, int var10, String var11, String var12);
    }
}

