/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.annotations.Beta;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.api.DOMRpcResult;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;

@Beta
@NonNullByDefault
public final class DefaultDOMRpcResult
implements DOMRpcResult,
Immutable,
Serializable {
    private static final long serialVersionUID = 1L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Interfaces do not specify Serializable")
    private final @Nullable ContainerNode result;
    private final Collection<? extends RpcError> errors;

    public DefaultDOMRpcResult(ContainerNode value, RpcError ... errors) {
        this(value, List.of(errors));
    }

    public DefaultDOMRpcResult(RpcError ... errors) {
        this(null, List.of(errors));
    }

    public DefaultDOMRpcResult(@Nullable ContainerNode result) {
        this(result, List.of());
    }

    public DefaultDOMRpcResult(@Nullable ContainerNode value, Collection<? extends RpcError> errors) {
        this.result = value;
        this.errors = Objects.requireNonNull(errors);
    }

    public DefaultDOMRpcResult(Collection<RpcError> errors) {
        this(null, errors);
    }

    public Collection<? extends RpcError> errors() {
        return this.errors;
    }

    public @Nullable ContainerNode value() {
        return this.result;
    }

    public int hashCode() {
        int ret = this.errors.hashCode();
        if (this.result != null) {
            ret = 31 * ret + this.result.hashCode();
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DefaultDOMRpcResult)) return false;
        DefaultDOMRpcResult other = (DefaultDOMRpcResult)obj;
        if (!this.errors.equals(other.errors)) return false;
        if (!Objects.equals(this.result, other.result)) return false;
        return true;
    }
}

