/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.spi;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.mdsal.dom.api.DOMMountPoint;
import org.opendaylight.mdsal.dom.api.DOMService;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

public final class SimpleDOMMountPoint
implements DOMMountPoint {
    private final YangInstanceIdentifier identifier;
    private final ClassToInstanceMap<DOMService> services;

    private SimpleDOMMountPoint(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services) {
        this.identifier = Objects.requireNonNull(identifier);
        this.services = ImmutableClassToInstanceMap.copyOf(services);
    }

    public static SimpleDOMMountPoint create(YangInstanceIdentifier identifier, ClassToInstanceMap<DOMService> services) {
        return new SimpleDOMMountPoint(identifier, services);
    }

    public YangInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public <T extends DOMService> Optional<T> getService(Class<T> cls) {
        return Optional.ofNullable((DOMService)this.services.getInstance(cls));
    }
}

