/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.ri;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.model.api.ConcreteType;
import org.opendaylight.mdsal.binding.model.api.Constant;
import org.opendaylight.mdsal.binding.model.api.GeneratedTransferObject;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.JavaTypeName;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.BaseIdentity;
import org.opendaylight.yangtools.yang.binding.BitsTypeObject;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.InstanceNotification;
import org.opendaylight.yangtools.yang.binding.Key;
import org.opendaylight.yangtools.yang.binding.KeyAware;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListAction;
import org.opendaylight.yangtools.yang.binding.KeyedListNotification;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.NotificationListener;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.binding.Rpc;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.binding.YangData;
import org.opendaylight.yangtools.yang.binding.YangFeature;
import org.opendaylight.yangtools.yang.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

public final class BindingTypes {
    public static final ConcreteType BASE_IDENTITY = Types.typeForClass(BaseIdentity.class);
    public static final ConcreteType DATA_CONTAINER = Types.typeForClass(DataContainer.class);
    public static final ConcreteType DATA_OBJECT = Types.typeForClass(DataObject.class);
    public static final ConcreteType DATA_ROOT = Types.typeForClass(DataRoot.class);
    @Deprecated(since="10.0.0", forRemoval=true)
    public static final ConcreteType NOTIFICATION_LISTENER = Types.typeForClass(NotificationListener.class);
    public static final ConcreteType QNAME = Types.typeForClass(QName.class);
    public static final ConcreteType RPC_INPUT = Types.typeForClass(RpcInput.class);
    public static final ConcreteType RPC_OUTPUT = Types.typeForClass(RpcOutput.class);
    @Deprecated(since="11.0.0", forRemoval=true)
    public static final ConcreteType RPC_SERVICE = Types.typeForClass(RpcService.class);
    public static final ConcreteType SCALAR_TYPE_OBJECT = Types.typeForClass(ScalarTypeObject.class);
    public static final ConcreteType BITS_TYPE_OBJECT = Types.typeForClass(BitsTypeObject.class);
    public static final ConcreteType UNION_TYPE_OBJECT = Types.typeForClass(UnionTypeObject.class);
    public static final ConcreteType INSTANCE_IDENTIFIER = Types.typeForClass(InstanceIdentifier.class);
    public static final ConcreteType KEYED_INSTANCE_IDENTIFIER = Types.typeForClass(KeyedInstanceIdentifier.class);
    public static final ConcreteType YANG_DATA_NAME = Types.typeForClass(YangDataName.class);
    public static final JavaTypeName ROUTING_CONTEXT = JavaTypeName.create(RoutingContext.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTABLE = Types.typeForClass(Augmentable.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTATION = Types.typeForClass(Augmentation.class);
    @VisibleForTesting
    static final ConcreteType KEY_AWARE = Types.typeForClass(KeyAware.class);
    @VisibleForTesting
    static final ConcreteType KEY = Types.typeForClass(Key.class);
    private static final ConcreteType ACTION = Types.typeForClass(Action.class);
    private static final ConcreteType CHILD_OF = Types.typeForClass(ChildOf.class);
    private static final ConcreteType CHOICE_IN = Types.typeForClass(ChoiceIn.class);
    private static final ConcreteType INSTANCE_NOTIFICATION = Types.typeForClass(InstanceNotification.class);
    private static final ConcreteType KEYED_LIST_ACTION = Types.typeForClass(KeyedListAction.class);
    private static final ConcreteType KEYED_LIST_NOTIFICATION = Types.typeForClass(KeyedListNotification.class);
    private static final ConcreteType NOTIFICATION = Types.typeForClass(Notification.class);
    private static final ConcreteType OPAQUE_OBJECT = Types.typeForClass(OpaqueObject.class);
    private static final ConcreteType RPC = Types.typeForClass(Rpc.class);
    private static final ConcreteType RPC_RESULT = Types.typeForClass(RpcResult.class);
    private static final ConcreteType YANG_FEATURE = Types.typeForClass(YangFeature.class);
    private static final ConcreteType YANG_DATA = Types.typeForClass(YangData.class);

    private BindingTypes() {
    }

    public static ParameterizedType action(Type parent, Type input, Type output) {
        return Types.parameterizedTypeFor((Type)ACTION, new Type[]{BindingTypes.instanceIdentifier(parent), input, output});
    }

    public static ParameterizedType keyedListAction(Type parent, Type keyType, Type input, Type output) {
        return Types.parameterizedTypeFor((Type)KEYED_LIST_ACTION, keyType, parent, input, output);
    }

    public static ParameterizedType notification(Type concreteType) {
        return Types.parameterizedTypeFor((Type)NOTIFICATION, concreteType);
    }

    public static ParameterizedType instanceNotification(Type concreteType, Type parent) {
        return Types.parameterizedTypeFor((Type)INSTANCE_NOTIFICATION, concreteType, parent);
    }

    public static ParameterizedType keyedListNotification(Type concreteType, Type parent, Type keyType) {
        return Types.parameterizedTypeFor((Type)KEYED_LIST_NOTIFICATION, concreteType, parent, keyType);
    }

    public static @NonNull ParameterizedType augmentable(Type type) {
        return Types.parameterizedTypeFor((Type)AUGMENTABLE, type);
    }

    public static @NonNull ParameterizedType augmentation(Type type) {
        return Types.parameterizedTypeFor((Type)AUGMENTATION, type);
    }

    public static ParameterizedType childOf(Type type) {
        return Types.parameterizedTypeFor((Type)CHILD_OF, type);
    }

    public static ParameterizedType choiceIn(Type type) {
        return Types.parameterizedTypeFor((Type)CHOICE_IN, type);
    }

    public static ParameterizedType key(Type type) {
        return Types.parameterizedTypeFor((Type)KEY, type);
    }

    public static ParameterizedType keyAware(Type type) {
        return Types.parameterizedTypeFor((Type)KEY_AWARE, type);
    }

    public static ParameterizedType instanceIdentifier(Type type) {
        return Types.parameterizedTypeFor((Type)INSTANCE_IDENTIFIER, type);
    }

    public static ParameterizedType keyedInstanceIdentifier(Type type, Type keyType) {
        return Types.parameterizedTypeFor((Type)KEYED_INSTANCE_IDENTIFIER, type, keyType);
    }

    public static ParameterizedType opaqueObject(Type type) {
        return Types.parameterizedTypeFor((Type)OPAQUE_OBJECT, type);
    }

    public static @NonNull ParameterizedType rpc(Type input, Type output) {
        return Types.parameterizedTypeFor((Type)RPC, input, output);
    }

    public static ParameterizedType rpcResult(Type type) {
        return Types.parameterizedTypeFor((Type)RPC_RESULT, type);
    }

    public static ParameterizedType scalarTypeObject(Type type) {
        return Types.parameterizedTypeFor((Type)SCALAR_TYPE_OBJECT, type);
    }

    public static ParameterizedType yangData(Type concreteType) {
        return Types.parameterizedTypeFor((Type)YANG_DATA, concreteType);
    }

    public static ParameterizedType yangFeature(Type concreteType, Type parent) {
        return Types.parameterizedTypeFor((Type)YANG_FEATURE, concreteType, parent);
    }

    public static boolean isBitsType(Type type) {
        GeneratedTransferObject gto;
        return type instanceof GeneratedTransferObject && BindingTypes.isBitsType(gto = (GeneratedTransferObject)type);
    }

    public static boolean isBitsType(GeneratedTransferObject gto) {
        return gto.isTypedef() && gto.getBaseType() instanceof BitsTypeDefinition;
    }

    public static boolean isIdentityType(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            for (Constant constant : generated.getConstantDefinitions()) {
                if (!"VALUE".equals(constant.getName()) || !BaseIdentity.class.equals(constant.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Beta
    public static @Nullable Type extractAugmentable(ParameterizedType type) {
        Type arg;
        Type[] args;
        if (AUGMENTATION.equals(type.getRawType()) && (args = type.getActualTypeArguments()).length == 1 && (arg = args[0]) != null) {
            return arg;
        }
        return null;
    }

    @Beta
    public static @Nullable Type extractKeyType(ParameterizedType type) {
        Type arg;
        Type[] args;
        if (KEY.equals(type.getRawType()) && (args = type.getActualTypeArguments()).length == 1 && (arg = args[0]) != null) {
            return arg;
        }
        return null;
    }

    @Beta
    public static @Nullable Type extractYangFeatureDataRoot(GeneratedTransferObject gto) {
        Type[] args;
        ParameterizedType param;
        Object e;
        List impls;
        if (!gto.isAbstract() && gto.getSuperType() == null && (impls = gto.getImplements()).size() == 1 && (e = impls.get(0)) instanceof ParameterizedType && YANG_FEATURE.equals((param = (ParameterizedType)e).getRawType()) && (args = param.getActualTypeArguments()).length == 2) {
            return args[1];
        }
        return null;
    }
}

