/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.delivery.internal;

import akka.actor.typed.ActorRef;
import akka.actor.typed.ActorRef$;
import akka.actor.typed.ActorRef$ActorRefOps$;
import akka.actor.typed.Behavior;
import akka.actor.typed.DispatcherSelector$;
import akka.actor.typed.delivery.ConsumerController;
import akka.actor.typed.delivery.DurableProducerQueue;
import akka.actor.typed.delivery.DurableProducerQueue$State$;
import akka.actor.typed.delivery.ProducerController;
import akka.actor.typed.delivery.internal.ChunkedMessage;
import akka.actor.typed.delivery.internal.ProducerControllerImpl;
import akka.actor.typed.delivery.internal.ProducerControllerImpl$DurableQueueTerminated$;
import akka.actor.typed.delivery.internal.ProducerControllerImpl$ResendFirst$;
import akka.actor.typed.internal.ActorFlightRecorder;
import akka.actor.typed.internal.ActorFlightRecorder$;
import akka.actor.typed.internal.DeliveryFlightRecorder;
import akka.actor.typed.scaladsl.ActorContext;
import akka.actor.typed.scaladsl.Behaviors$;
import akka.actor.typed.scaladsl.TimerScheduler;
import akka.serialization.Serialization;
import akka.serialization.Serializer;
import akka.serialization.Serializers$;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class ProducerControllerImpl$ {
    public static final ProducerControllerImpl$ MODULE$ = new ProducerControllerImpl$();

    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, ClassTag<A> evidence$1) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)context -> {
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
            context.setLoggerName("akka.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            return Behaviors$.MODULE$.withMdc((Map<String, String>)map, MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization((ActorContext<ProducerControllerImpl.InternalCommand>)context, (Option)None$.MODULE$, (Option)None$.MODULE$, durableQueue, settings, MODULE$.createInitialState(durableQueue.nonEmpty()), (Function3)(Function3 & Serializable)(producer, consumerController, loadedState) -> {
                Function1 & Serializable send = (Function1 & Serializable)x$1 -> {
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(consumerController), x$1);
                    return BoxedUnit.UNIT;
                };
                return MODULE$.becomeActive(producerId, durableQueue, settings, MODULE$.createState(context.self(), producerId, (Function1)send, (ActorRef)producer, (DurableProducerQueue.State)loadedState), evidence$1);
            }, evidence$1), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        }).narrow();
    }

    public <A> Behavior<ProducerController.Command<A>> apply(String producerId, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ClassTag<A> evidence$2) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)context -> {
            ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery().producerCreated(producerId, context.self().path());
            Map map = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"producerId"), (Object)producerId)}));
            context.setLoggerName("akka.actor.typed.delivery.ProducerController");
            Option durableQueue = MODULE$.askLoadState((ActorContext<ProducerControllerImpl.InternalCommand>)context, durableQueueBehavior, settings);
            return Behaviors$.MODULE$.withMdc((Map<String, String>)map, MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization((ActorContext<ProducerControllerImpl.InternalCommand>)context, (Option)None$.MODULE$, (Option)new Some(context.system().deadLetters()), durableQueue, settings, MODULE$.createInitialState(durableQueue.nonEmpty()), (Function3)(Function3 & Serializable)(producer, x$2, loadedState) -> MODULE$.becomeActive(producerId, durableQueue, settings, MODULE$.createState(context.self(), producerId, send, (ActorRef)producer, (DurableProducerQueue.State)loadedState), evidence$2), evidence$2), ClassTag$.MODULE$.apply(ProducerControllerImpl.InternalCommand.class));
        }).narrow();
    }

    private <A> Option<ActorRef<DurableProducerQueue.Command<A>>> askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<Behavior<DurableProducerQueue.Command<A>>> durableQueueBehavior, ProducerController.Settings settings) {
        return durableQueueBehavior.map((Function1 & Serializable)b -> {
            void var3_3;
            ActorRef ref = context.spawn(b, "durable", DispatcherSelector$.MODULE$.sameAsParent());
            context.watchWith(ref, ProducerControllerImpl$DurableQueueTerminated$.MODULE$);
            MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(context, (Option)new Some(ref), settings, 1);
            return var3_3;
        });
    }

    public <A> void akka$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, int attempt) {
        Timeout loadTimeout = Timeout$.MODULE$.durationToTimeout(settings.durableQueueRequestTimeout());
        durableQueue.foreach((Function1 & Serializable)ref -> {
            context.ask(ref, (Function1 & Serializable)askReplyTo -> new DurableProducerQueue.LoadState(askReplyTo), (Function1 & Serializable)x0$1 -> {
                ProducerControllerImpl.InternalCommand internalCommand;
                Try try_ = x0$1;
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    DurableProducerQueue.State s = (DurableProducerQueue.State)success.value();
                    internalCommand = new ProducerControllerImpl.LoadStateReply(s);
                } else if (try_ instanceof Failure) {
                    internalCommand = new ProducerControllerImpl.LoadStateFailed(attempt$1);
                } else {
                    throw new MatchError((Object)try_);
                }
                return internalCommand;
            }, loadTimeout, ClassTag$.MODULE$.apply(DurableProducerQueue.State.class));
            return BoxedUnit.UNIT;
        });
    }

    private <A> Option<DurableProducerQueue.State<A>> createInitialState(boolean hasDurableQueue) {
        return hasDurableQueue ? None$.MODULE$ : new Some(DurableProducerQueue$State$.MODULE$.empty());
    }

    private <A> ProducerControllerImpl.State<A> createState(ActorRef<ProducerControllerImpl.InternalCommand> self, String producerId, Function1<ConsumerController.SequencedMessage<A>, BoxedUnit> send, ActorRef<ProducerController.RequestNext<A>> producer, DurableProducerQueue.State<A> loadedState) {
        Vector unconfirmed = (Vector)((StrictOptimizedIterableOps)loadedState.unconfirmed().toVector().zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DurableProducerQueue.MessageSent u = (DurableProducerQueue.MessageSent)tuple2._1();
            int i = tuple2._2$mcI$sp();
            ConsumerController.SequencedMessage sequencedMessage = new ConsumerController.SequencedMessage(producerId, u.seqNr(), u.message(), i == 0, u.ack(), self);
            return sequencedMessage;
        });
        return new ProducerControllerImpl.State<A>(false, loadedState.currentSeqNr(), loadedState.highestConfirmedSeqNr(), 1L, (Map<Object, ActorRef<Object>>)Predef$.MODULE$.Map().empty(), true, unconfirmed, package$.MODULE$.Nil(), 0L, loadedState.highestConfirmedSeqNr() + 1L, producer, send);
    }

    public <A> Behavior<ProducerControllerImpl.InternalCommand> akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(ActorContext<ProducerControllerImpl.InternalCommand> context, Option<ActorRef<ProducerController.RequestNext<A>>> producer, Option<ActorRef<ConsumerController.Command<A>>> consumerController, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, Option<DurableProducerQueue.State<A>> initialState, Function3<ActorRef<ProducerController.RequestNext<A>>, ActorRef<ConsumerController.Command<A>>, DurableProducerQueue.State<A>, Behavior<ProducerControllerImpl.InternalCommand>> thenBecomeActive, ClassTag<A> evidence$3) {
        return (Behavior)((Object)Behaviors$.MODULE$.receiveMessagePartial(new Serializable(producer, initialState, thenBecomeActive, context, durableQueue, settings, evidence$3, consumerController){
            private static final long serialVersionUID = 0L;
            private final Option producer$1;
            private final Option initialState$1;
            private final Function3 thenBecomeActive$1;
            private final ActorContext context$5;
            private final Option durableQueue$3;
            private final ProducerController.Settings settings$4;
            private final ClassTag evidence$3$1;
            private final Option consumerController$2;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final <A1 extends ProducerControllerImpl.InternalCommand, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> default) {
                block17: {
                    block19: {
                        block18: {
                            block16: {
                                var7_3 = x1;
                                if (!(var7_3 instanceof ProducerController.RegisterConsumer) || !((c = (var8_4 = (ProducerController.RegisterConsumer)var7_3).consumerController()) instanceof ActorRef)) break block16;
                                var10_6 = c;
                                var11_7 = new Tuple2((Object)this.producer$1, (Object)this.initialState$1);
                                if (var11_7 == null) ** GOTO lbl-1000
                                var12_8 = (Option)var11_7._1();
                                var13_9 = (Option)var11_7._2();
                                if (!(var12_8 instanceof Some)) ** GOTO lbl-1000
                                var14_10 = (Some)var12_8;
                                p = (ActorRef)var14_10.value();
                                if (var13_9 instanceof Some) {
                                    var16_12 = (Some)var13_9;
                                    s = (DurableProducerQueue.State)var16_12.value();
                                    var6_14 = (Behavior)this.thenBecomeActive$1.apply((Object)p, var10_6, (Object)s);
                                } else if (var11_7 != null) {
                                    var6_14 = ProducerControllerImpl$.MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, this.producer$1, new Some(var10_6), this.durableQueue$3, this.settings$4, this.initialState$1, this.thenBecomeActive$1, this.evidence$3$1);
                                } else {
                                    throw new MatchError((Object)var11_7);
                                }
                                var3_15 /* !! */  = var6_14;
                                break block17;
                            }
                            if (!(var7_3 instanceof ProducerController.Start)) break block18;
                            var18_16 = (ProducerController.Start)var7_3;
                            var19_17 = new Tuple2((Object)this.consumerController$2, (Object)this.initialState$1);
                            if (var19_17 == null) ** GOTO lbl-1000
                            var20_18 = (Option)var19_17._1();
                            var21_19 = (Option)var19_17._2();
                            if (!(var20_18 instanceof Some)) ** GOTO lbl-1000
                            var22_20 = (Some)var20_18;
                            c = (ActorRef)var22_20.value();
                            if (var21_19 instanceof Some) {
                                var24_22 = (Some)var21_19;
                                s = (DurableProducerQueue.State)var24_22.value();
                                var5_24 = (Behavior)this.thenBecomeActive$1.apply(var18_16.producer(), (Object)c, (Object)s);
                            } else if (var19_17 != null) {
                                var5_24 = ProducerControllerImpl$.MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, new Some(var18_16.producer()), this.consumerController$2, this.durableQueue$3, this.settings$4, this.initialState$1, this.thenBecomeActive$1, this.evidence$3$1);
                            } else {
                                throw new MatchError((Object)var19_17);
                            }
                            var3_15 /* !! */  = var5_24;
                            break block17;
                        }
                        if (!(var7_3 instanceof ProducerControllerImpl.LoadStateReply)) break block19;
                        var26_25 = (ProducerControllerImpl.LoadStateReply)var7_3;
                        var27_26 = new Tuple2((Object)this.producer$1, (Object)this.consumerController$2);
                        if (var27_26 == null) ** GOTO lbl-1000
                        var28_27 = (Option)var27_26._1();
                        var29_28 = (Option)var27_26._2();
                        if (!(var28_27 instanceof Some)) ** GOTO lbl-1000
                        var30_29 = (Some)var28_27;
                        p = (ActorRef)var30_29.value();
                        if (var29_28 instanceof Some) {
                            var32_31 = (Some)var29_28;
                            c = (ActorRef)var32_31.value();
                            var4_33 = (Behavior)this.thenBecomeActive$1.apply((Object)p, (Object)c, var26_25.state());
                        } else if (var27_26 != null) {
                            var4_33 = ProducerControllerImpl$.MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$waitingForInitialization(this.context$5, this.producer$1, this.consumerController$2, this.durableQueue$3, this.settings$4, new Some(var26_25.state()), this.thenBecomeActive$1, this.evidence$3$1);
                        } else {
                            throw new MatchError((Object)var27_26);
                        }
                        var3_15 /* !! */  = var4_33;
                        break block17;
                    }
                    if (var7_3 instanceof ProducerControllerImpl.LoadStateFailed) {
                        var34_34 = (ProducerControllerImpl.LoadStateFailed)var7_3;
                        attempt = var34_34.attempt();
                        if (attempt >= this.settings$4.durableQueueRetryAttempts()) {
                            errorMessage = new StringBuilder(46).append("LoadState failed after [").append(attempt).append("] attempts, giving up.").toString();
                            this.context$5.log().error(errorMessage);
                            throw new TimeoutException(errorMessage);
                        }
                        this.context$5.log().warn("LoadState failed, attempt [{}] of [{}], retrying.", (Object)BoxesRunTime.boxToInteger((int)attempt), (Object)BoxesRunTime.boxToInteger((int)this.settings$4.durableQueueRetryAttempts()));
                        ProducerControllerImpl$.MODULE$.akka$actor$typed$delivery$internal$ProducerControllerImpl$$askLoadState(this.context$5, this.durableQueue$3, this.settings$4, attempt + 1);
                        var3_15 /* !! */  = Behaviors$.MODULE$.same();
                    } else {
                        if (ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(var7_3)) {
                            throw new IllegalStateException("DurableQueue was unexpectedly terminated.");
                        }
                        var3_15 /* !! */  = default.apply(x1);
                    }
                }
                return (B1)var3_15 /* !! */ ;
            }

            public final boolean isDefinedAt(ProducerControllerImpl.InternalCommand x1) {
                ProducerController.RegisterConsumer registerConsumer;
                ActorRef<ConsumerController.Command<A>> c;
                ProducerControllerImpl.InternalCommand internalCommand = x1;
                boolean bl = internalCommand instanceof ProducerController.RegisterConsumer && (c = (registerConsumer = (ProducerController.RegisterConsumer)internalCommand).consumerController()) instanceof ActorRef ? true : (internalCommand instanceof ProducerController.Start ? true : (internalCommand instanceof ProducerControllerImpl.LoadStateReply ? true : (internalCommand instanceof ProducerControllerImpl.LoadStateFailed ? true : ProducerControllerImpl$DurableQueueTerminated$.MODULE$.equals(internalCommand))));
                return bl;
            }
            {
                this.producer$1 = producer$1;
                this.initialState$1 = initialState$1;
                this.thenBecomeActive$1 = thenBecomeActive$1;
                this.context$5 = context$5;
                this.durableQueue$3 = durableQueue$3;
                this.settings$4 = settings$4;
                this.evidence$3$1 = evidence$3$1;
                this.consumerController$2 = consumerController$2;
            }
        }));
    }

    private <A> Behavior<ProducerControllerImpl.InternalCommand> becomeActive(String producerId, Option<ActorRef<DurableProducerQueue.Command<A>>> durableQueue, ProducerController.Settings settings, ProducerControllerImpl.State<A> state, ClassTag<A> evidence$4) {
        return Behaviors$.MODULE$.setup((Function1 & Serializable)context -> {
            DeliveryFlightRecorder flightRecorder = ((ActorFlightRecorder)ActorFlightRecorder$.MODULE$.apply(context.system())).delivery();
            flightRecorder.producerStarted(producerId, context.self().path());
            return Behaviors$.MODULE$.withTimers((Function1 & Serializable)timers -> {
                boolean bl;
                ActorRef msgAdapter = context.messageAdapter((Function1 & Serializable)msg -> new ProducerControllerImpl.Msg<Object>(msg), evidence$4);
                if (state.unconfirmed().isEmpty()) {
                    flightRecorder.producerRequestNext(producerId, 1L, 0L);
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(state.producer()), new ProducerController.RequestNext(producerId, 1L, 0L, msgAdapter, context.self()));
                    bl = true;
                } else {
                    context.log().debug("Starting with [{}] unconfirmed.", (Object)BoxesRunTime.boxToInteger((int)state.unconfirmed().size()));
                    ActorRef$ActorRefOps$.MODULE$.$bang$extension(ActorRef$.MODULE$.ActorRefOps(context.self()), ProducerControllerImpl$ResendFirst$.MODULE$);
                    bl = false;
                }
                boolean requested = bl;
                return new ProducerControllerImpl((ActorContext<ProducerControllerImpl.InternalCommand>)context, producerId, durableQueue, settings, msgAdapter, (TimerScheduler<ProducerControllerImpl.InternalCommand>)timers, evidence$4).akka$actor$typed$delivery$internal$ProducerControllerImpl$$active(state.copy(requested, state.copy$default$2(), state.copy$default$3(), state.copy$default$4(), state.copy$default$5(), state.copy$default$6(), state.copy$default$7(), state.copy$default$8(), state.copy$default$9(), state.copy$default$10(), state.copy$default$11(), state.copy$default$12()));
            });
        });
    }

    public void enforceLocalProducer(ActorRef<?> ref) {
        if (ref.path().address().hasGlobalScope()) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Consumer [").append(ref).append("] should be local.").toString());
        }
    }

    public <A> Seq<ChunkedMessage> createChunks(A m, int chunkSize, Serialization serialization) {
        List list;
        A mAnyRef = m;
        byte[] bytes = (byte[])serialization.serialize(mAnyRef).get();
        Serializer ser = serialization.findSerializerFor(mAnyRef);
        String manifest = Serializers$.MODULE$.manifestFor(ser, mAnyRef);
        int serializerId = ser.identifier();
        if (bytes.length <= chunkSize) {
            ChunkedMessage chunkedMessage = new ChunkedMessage(ByteString$.MODULE$.fromArrayUnsafe(bytes), true, true, serializerId, manifest);
            list = package$.MODULE$.Nil().$colon$colon((Object)chunkedMessage);
        } else {
            ReusableBuilder builder = package$.MODULE$.Vector().newBuilder();
            Iterator<ByteString> chunksIter = ByteString$.MODULE$.fromArrayUnsafe(bytes).grouped(chunkSize);
            boolean first = true;
            while (chunksIter.hasNext()) {
                ByteString chunk = (ByteString)chunksIter.next();
                boolean firstChunk = first;
                first = false;
                boolean lastChunk = !chunksIter.hasNext();
                builder.$plus$eq((Object)new ChunkedMessage(chunk, firstChunk, lastChunk, serializerId, manifest));
            }
            list = (Seq)builder.result();
        }
        return list;
    }

    private ProducerControllerImpl$() {
    }
}

