/*
 * Decompiled with CFR 0.152.
 */
package akka.actor.typed.internal;

import akka.actor.ActorPath;
import akka.actor.typed.Behavior;
import akka.actor.typed.BehaviorInterceptor;
import akka.actor.typed.LogOptions;
import akka.actor.typed.Signal;
import akka.actor.typed.TypedActorContext;
import akka.actor.typed.internal.LogMessagesInterceptor$;
import akka.annotation.InternalApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005%sA\u0002\n\u0014\u0011\u0003I2D\u0002\u0004\u001e'!\u0005\u0011D\b\u0005\u0006K\u0005!\ta\n\u0005\u0006Q\u0005!\t!\u000b\u0005\b\u007f\u0005\u0011\r\u0011\"\u0003A\u0011\u0019I\u0015\u0001)A\u0005\u0003\"9!*\u0001b\u0001\n\u0013\u0001\u0005BB&\u0002A\u0003%\u0011IB\u0003\u001e'\tIB\u000b\u0003\u0005<\u0011\t\u0015\r\u0011\"\u0001W\u0011!9\u0006B!A!\u0002\u0013a\u0004\"B\u0013\t\t\u0003A\u0006bB.\t\u0005\u0004%I\u0001\u0018\u0005\u0007K\"\u0001\u000b\u0011B/\t\u000b\u0019DA\u0011I4\t\u000bmDA\u0011\t?\t\u000f\u0005=\u0001\u0002\"\u0003\u0002\u0012!9\u0011\u0011\b\u0005\u0005B\u0005m\u0012A\u0006'pO6+7o]1hKNLe\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0005Q)\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Y9\u0012!\u0002;za\u0016$'B\u0001\r\u001a\u0003\u0015\t7\r^8s\u0015\u0005Q\u0012\u0001B1lW\u0006\u0004\"\u0001H\u0001\u000e\u0003M\u0011a\u0003T8h\u001b\u0016\u001c8/Y4fg&sG/\u001a:dKB$xN]\n\u0003\u0003}\u0001\"\u0001I\u0012\u000e\u0003\u0005R\u0011AI\u0001\u0006g\u000e\fG.Y\u0005\u0003I\u0005\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003m\tQ!\u00199qYf,\"AK\u0019\u0015\u0005-R\u0004\u0003\u0002\u0017._=j\u0011!F\u0005\u0003]U\u00111CQ3iCZLwN]%oi\u0016\u00148-\u001a9u_J\u0004\"\u0001M\u0019\r\u0001\u0011)!g\u0001b\u0001g\t\tA+\u0005\u00025oA\u0011\u0001%N\u0005\u0003m\u0005\u0012qAT8uQ&tw\r\u0005\u0002!q%\u0011\u0011(\t\u0002\u0004\u0003:L\b\"B\u001e\u0004\u0001\u0004a\u0014\u0001B8qiN\u0004\"\u0001L\u001f\n\u0005y*\"A\u0003'pO>\u0003H/[8og\u0006\u0011Bj\\4NKN\u001c\u0018mZ3UK6\u0004H.\u0019;f+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u0007'R\u0014\u0018N\\4\u0002'1{w-T3tg\u0006<W\rV3na2\fG/\u001a\u0011\u0002#1{wmU5h]\u0006dG+Z7qY\u0006$X-\u0001\nM_\u001e\u001c\u0016n\u001a8bYR+W\u000e\u001d7bi\u0016\u0004\u0003FA\u0001N!\tq\u0015+D\u0001P\u0015\t\u0001\u0016$\u0001\u0006b]:|G/\u0019;j_:L!AU(\u0003\u0017%sG/\u001a:oC2\f\u0005/\u001b\u0015\u0003\u00015\u001b\"\u0001C+\u0011\t1jsgN\u000b\u0002y\u0005)q\u000e\u001d;tAQ\u0011\u0011L\u0017\t\u00039!AQaO\u0006A\u0002q\na\u0001\\8hO\u0016\u0014X#A/\u0011\u0005y\u001bW\"A0\u000b\u0005\u0001\f\u0017!B:mMRR'\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e?\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0007be>,h\u000e\u001a*fG\u0016Lg/\u001a\u000b\u0005Q.\u0004(\u000fE\u0002-S^J!A[\u000b\u0003\u0011\t+\u0007.\u0019<j_JDQ\u0001\u001c\bA\u00025\f1a\u0019;y!\racnN\u0005\u0003_V\u0011\u0011\u0003V=qK\u0012\f5\r^8s\u0007>tG/\u001a=u\u0011\u0015\th\u00021\u00018\u0003\ri7o\u001a\u0005\u0006g:\u0001\r\u0001^\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0007UDxG\u0004\u0002-m&\u0011q/F\u0001\u0014\u0005\u0016D\u0017M^5pe&sG/\u001a:dKB$xN]\u0005\u0003sj\u0014QBU3dK&4X\rV1sO\u0016$(BA<\u0016\u00031\t'o\\;oINKwM\\1m)\u0015AWP`A\u0004\u0011\u0015aw\u00021\u0001n\u0011\u0019yx\u00021\u0001\u0002\u0002\u000511/[4oC2\u00042\u0001LA\u0002\u0013\r\t)!\u0006\u0002\u0007'&<g.\u00197\t\rM|\u0001\u0019AA\u0005!\u0011)\u00181B\u001c\n\u0007\u00055!P\u0001\u0007TS\u001et\u0017\r\u001c+be\u001e,G/A\u0002m_\u001e$\u0002\"a\u0005\u0002\u001a\u0005E\u0012Q\u0007\t\u0004A\u0005U\u0011bAA\fC\t!QK\\5u\u0011\u001d\tY\u0002\u0005a\u0001\u0003;\t\u0001\u0002^3na2\fG/\u001a\t\u0005\u0003?\tiC\u0004\u0003\u0002\"\u0005%\u0002cAA\u0012C5\u0011\u0011Q\u0005\u0006\u0004\u0003O1\u0013A\u0002\u001fs_>$h(C\u0002\u0002,\u0005\na\u0001\u0015:fI\u00164\u0017b\u0001%\u00020)\u0019\u00111F\u0011\t\r\u0005M\u0002\u00031\u00018\u0003=iWm]:bO\u0016|%oU5h]\u0006d\u0007BBA\u001c!\u0001\u0007Q.A\u0004d_:$X\r\u001f;\u0002\r%\u001c8+Y7f)\u0011\ti$a\u0011\u0011\u0007\u0001\ny$C\u0002\u0002B\u0005\u0012qAQ8pY\u0016\fg\u000e\u0003\u0004\u0002FE\u0001\r!V\u0001\u0006_RDWM\u001d\u0015\u0003\u00115\u0003")
@InternalApi
public final class LogMessagesInterceptor
extends BehaviorInterceptor<Object, Object> {
    private final LogOptions opts;
    private final Logger logger;

    public static <T> BehaviorInterceptor<T, T> apply(LogOptions opts) {
        return LogMessagesInterceptor$.MODULE$.apply(opts);
    }

    public LogOptions opts() {
        return this.opts;
    }

    private Logger logger() {
        return this.logger;
    }

    @Override
    public Behavior<Object> aroundReceive(TypedActorContext<Object> ctx, Object msg, BehaviorInterceptor.ReceiveTarget<Object> target) {
        this.log(LogMessagesInterceptor$.MODULE$.akka$actor$typed$internal$LogMessagesInterceptor$$LogMessageTemplate(), msg, ctx);
        return target.apply(ctx, msg);
    }

    @Override
    public Behavior<Object> aroundSignal(TypedActorContext<Object> ctx, Signal signal, BehaviorInterceptor.SignalTarget<Object> target) {
        this.log(LogMessagesInterceptor$.MODULE$.akka$actor$typed$internal$LogMessagesInterceptor$$LogSignalTemplate(), signal, ctx);
        return target.apply(ctx, signal);
    }

    private void log(String template, Object messageOrSignal, TypedActorContext<Object> context) {
        if (this.opts().enabled()) {
            ActorPath selfPath = context.asScala().self().path();
            Level level = this.opts().level();
            if (Level.ERROR.equals(level)) {
                this.logger().error(template, (Object)selfPath, messageOrSignal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Level.WARN.equals(level)) {
                this.logger().warn(template, (Object)selfPath, messageOrSignal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Level.INFO.equals(level)) {
                this.logger().info(template, (Object)selfPath, messageOrSignal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Level.DEBUG.equals(level)) {
                this.logger().debug(template, (Object)selfPath, messageOrSignal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Level.TRACE.equals(level)) {
                this.logger().trace(template, (Object)selfPath, messageOrSignal);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)level);
            }
        }
    }

    @Override
    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        boolean bl;
        BehaviorInterceptor<Object, Object> behaviorInterceptor = other;
        if (behaviorInterceptor instanceof LogMessagesInterceptor) {
            LogMessagesInterceptor logMessagesInterceptor = (LogMessagesInterceptor)behaviorInterceptor;
            LogOptions logOptions = logMessagesInterceptor.opts();
            LogOptions logOptions2 = this.opts();
            bl = !(logOptions != null ? !logOptions.equals(logOptions2) : logOptions2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public LogMessagesInterceptor(LogOptions opts) {
        this.opts = opts;
        super(ClassTag$.MODULE$.Any());
        this.logger = opts.getLogger().orElse(LoggerFactory.getLogger(this.getClass()));
    }
}

