/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.dsbenchmark.txchain;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.ExecutionException;
import org.opendaylight.dsbenchmark.DatastoreAbstractWriter;
import org.opendaylight.dsbenchmark.txchain.TxchainDomWrite;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataBroker;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.StartTestInput;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.TestExec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.dsbenchmark.rev150105.test.exec.OuterList;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxchainDomDelete
extends DatastoreAbstractWriter
implements DOMTransactionChainListener {
    private static final Logger LOG = LoggerFactory.getLogger(TxchainDomDelete.class);
    private final DOMDataBroker domDataBroker;

    public TxchainDomDelete(DOMDataBroker domDataBroker, int outerListElem, int innerListElem, long writesPerTx, StartTestInput.DataStore dataStore) {
        super(StartTestInput.Operation.DELETE, outerListElem, innerListElem, writesPerTx, dataStore);
        this.domDataBroker = domDataBroker;
        LOG.debug("Created TxchainDomDelete");
    }

    @Override
    public void createList() {
        LOG.debug("TxchainDomDelete: creating data in the data store");
        TxchainDomWrite dd = new TxchainDomWrite(this.domDataBroker, StartTestInput.Operation.PUT, this.outerListElem, this.innerListElem, this.outerListElem, this.dataStore);
        dd.createList();
        dd.executeList();
    }

    @Override
    public void executeList() {
        LogicalDatastoreType dsType = this.getDataStoreType();
        QName olId = QName.create((QName)OuterList.QNAME, (String)"id");
        YangInstanceIdentifier pid = YangInstanceIdentifier.builder().node(TestExec.QNAME).node(OuterList.QNAME).build();
        DOMTransactionChain chain = this.domDataBroker.createMergingTransactionChain((DOMTransactionChainListener)this);
        DOMDataTreeWriteTransaction tx = chain.newWriteOnlyTransaction();
        int txSubmitted = 0;
        int writeCnt = 0;
        for (int l = 0; l < this.outerListElem; ++l) {
            YangInstanceIdentifier yid = pid.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)OuterList.QNAME, (QName)olId, (Object)l));
            tx.delete(dsType, yid);
            if ((long)(++writeCnt) != this.writesPerTx) continue;
            ++txSubmitted;
            tx.commit().addCallback((FutureCallback)new FutureCallback<CommitInfo>(){

                public void onSuccess(CommitInfo result) {
                    TxchainDomDelete.this.txOk++;
                }

                public void onFailure(Throwable cause) {
                    LOG.error("Transaction failed", cause);
                    TxchainDomDelete.this.txError++;
                }
            }, MoreExecutors.directExecutor());
            tx = chain.newWriteOnlyTransaction();
            writeCnt = 0;
        }
        try {
            ++txSubmitted;
            tx.commit().get();
            ++this.txOk;
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.error("Transaction failed", (Throwable)e);
            ++this.txError;
        }
        try {
            chain.close();
        }
        catch (IllegalStateException e) {
            LOG.error("Transaction close failed,", (Throwable)e);
        }
        LOG.debug("Transactions: submitted {}, completed {}", (Object)txSubmitted, (Object)(this.txOk + this.txError));
    }

    public void onTransactionChainFailed(DOMTransactionChain chain, DOMDataTreeTransaction transaction, Throwable cause) {
        LOG.error("Broken chain {} in TxchainDomDelete, transaction {}", new Object[]{chain, transaction.getIdentifier(), cause});
    }

    public void onTransactionChainSuccessful(DOMTransactionChain chain) {
        LOG.debug("TxchainDomDelete closed successfully, chain {}", (Object)chain);
    }
}

