/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft;

import org.opendaylight.controller.cluster.DataPersistenceProvider;
import org.opendaylight.controller.cluster.raft.ElectionTerm;
import org.opendaylight.controller.cluster.raft.NoopProcedure;
import org.opendaylight.controller.cluster.raft.persisted.UpdateElectionTerm;
import org.slf4j.Logger;

class ElectionTermImpl
implements ElectionTerm {
    private long currentTerm = 0L;
    private String votedFor = null;
    private final DataPersistenceProvider persistence;
    private final Logger log;
    private final String logId;

    ElectionTermImpl(DataPersistenceProvider persistence, String logId, Logger log) {
        this.persistence = persistence;
        this.logId = logId;
        this.log = log;
    }

    @Override
    public long getCurrentTerm() {
        return this.currentTerm;
    }

    @Override
    public String getVotedFor() {
        return this.votedFor;
    }

    @Override
    public void update(long newTerm, String newVotedFor) {
        this.log.debug("{}: Set currentTerm={}, votedFor={}", new Object[]{this.logId, newTerm, newVotedFor});
        this.currentTerm = newTerm;
        this.votedFor = newVotedFor;
    }

    @Override
    public void updateAndPersist(long newTerm, String newVotedFor) {
        this.update(newTerm, newVotedFor);
        this.persistence.persist((Object)new UpdateElectionTerm(this.currentTerm, this.votedFor), NoopProcedure.instance());
    }
}

