/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.raft.behaviors;

import akka.actor.ActorRef;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.controller.cluster.raft.RaftActorContext;
import org.opendaylight.controller.cluster.raft.RaftState;
import org.opendaylight.controller.cluster.raft.behaviors.AbstractLeader;
import org.opendaylight.controller.cluster.raft.behaviors.Leader;
import org.opendaylight.controller.cluster.raft.behaviors.RaftActorBehavior;
import org.opendaylight.controller.cluster.raft.messages.AppendEntriesReply;

public class IsolatedLeader
extends AbstractLeader {
    IsolatedLeader(RaftActorContext context, @Nullable AbstractLeader initializeFromLeader) {
        super(context, RaftState.IsolatedLeader, initializeFromLeader);
    }

    public IsolatedLeader(RaftActorContext context) {
        this(context, (AbstractLeader)null);
    }

    @Override
    protected RaftActorBehavior handleAppendEntriesReply(ActorRef sender, AppendEntriesReply appendEntriesReply) {
        RaftActorBehavior ret = super.handleAppendEntriesReply(sender, appendEntriesReply);
        if (ret.state() == RaftState.IsolatedLeader && !this.isLeaderIsolated()) {
            this.log.info("IsolatedLeader {} switching from IsolatedLeader to Leader", (Object)this.getLeaderId());
            return this.internalSwitchBehavior(new Leader(this.context, this));
        }
        return ret;
    }
}

