/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.access.concepts;

import com.google.common.base.Verify;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.opendaylight.controller.cluster.access.concepts.FrontendIdentifier;
import org.opendaylight.controller.cluster.access.concepts.FrontendType;
import org.opendaylight.controller.cluster.access.concepts.MemberName;

final class FI
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private FrontendIdentifier identifier;

    public FI() {
    }

    FI(FrontendIdentifier identifier) {
        this.identifier = Objects.requireNonNull(identifier);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.identifier = new FrontendIdentifier(MemberName.readFrom(in), FrontendType.readFrom(in));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.identifier.getMemberName().writeTo(out);
        this.identifier.getClientType().writeTo(out);
    }

    private Object readResolve() {
        return Verify.verifyNotNull((Object)this.identifier);
    }
}

