/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCursorAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCursorAware.class);
    private static final VarHandle CURSOR;
    private volatile AbstractCursor<?> cursor;

    AbstractCursorAware() {
    }

    protected <T extends AbstractCursor<?>> T openCursor(T cursorToOpen) {
        AbstractCursor witness = CURSOR.compareAndExchange(this, null, cursorToOpen);
        if (witness != null) {
            throw new IllegalStateException("Modification " + this + " has cursor attached at path " + witness.getRootPath());
        }
        return cursorToOpen;
    }

    final void closeCursor(AbstractCursor<?> cursorToClose) {
        AbstractCursor witness = CURSOR.compareAndExchange(this, cursorToClose, null);
        if (witness != cursorToClose) {
            LOG.warn("Attempted to close cursor {} while {} is open", cursorToClose, (Object)witness);
        }
    }

    static {
        try {
            CURSOR = MethodHandles.lookup().findVarHandle(AbstractCursorAware.class, "cursor", AbstractCursor.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

