/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeTip;
import org.opendaylight.yangtools.yang.data.tree.api.DataValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.InMemoryDataTreeModification;
import org.opendaylight.yangtools.yang.data.tree.impl.LogicalOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NoopDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;

abstract class AbstractDataTreeTip
implements DataTreeTip {
    AbstractDataTreeTip() {
    }

    protected abstract @NonNull TreeNode getTipRoot();

    abstract @NonNull YangInstanceIdentifier getRootPath();

    public final void validate(DataTreeModification modification) throws DataValidationFailedException {
        InMemoryDataTreeModification m = AbstractDataTreeTip.checkedCast(modification);
        Preconditions.checkArgument((boolean)m.isSealed(), (String)"Attempted to verify unsealed modification %s", (Object)m);
        m.getStrategy().checkApplicable(new ModificationPath(this.getRootPath()), m.getRootModification(), Optional.of(this.getTipRoot()), m.getVersion());
    }

    public final DataTreeCandidateTip prepare(DataTreeModification modification) {
        InMemoryDataTreeModification m = AbstractDataTreeTip.checkedCast(modification);
        Preconditions.checkArgument((boolean)m.isSealed(), (String)"Attempted to prepare unsealed modification %s", (Object)m);
        ModifiedNode root = m.getRootModification();
        TreeNode currentRoot = this.getTipRoot();
        if (root.getOperation() == LogicalOperation.NONE) {
            return new NoopDataTreeCandidate(YangInstanceIdentifier.of(), root, currentRoot);
        }
        Optional<? extends TreeNode> newRoot = m.getStrategy().apply(m.getRootModification(), Optional.of(currentRoot), m.getVersion());
        Preconditions.checkState((boolean)newRoot.isPresent(), (String)"Apply strategy failed to produce root node for modification %s", (Object)modification);
        return new InMemoryDataTreeCandidate(YangInstanceIdentifier.of(), root, currentRoot, newRoot.orElseThrow());
    }

    private static InMemoryDataTreeModification checkedCast(DataTreeModification mod) {
        Preconditions.checkArgument((boolean)(mod instanceof InMemoryDataTreeModification), (String)"Invalid modification class %s", mod.getClass());
        return (InMemoryDataTreeModification)mod;
    }
}

