/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.DistinctNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.builder.impl.ImmutableContainerNodeBuilder;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.impl.DataNodeContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.MandatoryLeafEnforcer;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModifiedNode;
import org.opendaylight.yangtools.yang.data.tree.impl.NormalizedNodeContainerSupport;
import org.opendaylight.yangtools.yang.data.tree.impl.StructuralContainerModificationStrategy;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.data.tree.impl.node.Version;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;

class ContainerModificationStrategy
extends DataNodeContainerModificationStrategy<ContainerLike> {
    private static final NormalizedNodeContainerSupport<YangInstanceIdentifier.NodeIdentifier, ContainerNode> SUPPORT = new NormalizedNodeContainerSupport(ContainerNode.class, ImmutableContainerNodeBuilder::create, ImmutableContainerNodeBuilder::create);

    ContainerModificationStrategy(ContainerLike schemaNode, DataTreeConfiguration treeConfig) {
        super(SUPPORT, schemaNode, treeConfig);
    }

    static ModificationApplyOperation of(ContainerSchemaNode schema, DataTreeConfiguration treeConfig) {
        if (schema.isPresenceContainer()) {
            MandatoryLeafEnforcer enforcer = MandatoryLeafEnforcer.forContainer((DataNodeContainer)schema, treeConfig);
            return enforcer != null ? new EnforcingMandatory(schema, treeConfig, enforcer) : new ContainerModificationStrategy((ContainerLike)schema, treeConfig);
        }
        return new StructuralContainerModificationStrategy((ContainerLike)schema, treeConfig);
    }

    private static final class EnforcingMandatory
    extends ContainerModificationStrategy {
        private final MandatoryLeafEnforcer enforcer;

        EnforcingMandatory(ContainerSchemaNode schemaNode, DataTreeConfiguration treeConfig, MandatoryLeafEnforcer enforcer) {
            super((ContainerLike)schemaNode, treeConfig);
            this.enforcer = Objects.requireNonNull(enforcer);
        }

        @Override
        void mandatoryVerifyValueChildren(DistinctNodeContainer<?, ?> writtenValue) {
            this.enforcer.enforceOnData((NormalizedNode)writtenValue);
        }

        @Override
        protected TreeNode applyMerge(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyMerge(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyWrite(ModifiedNode modification, NormalizedNode newValue, Optional<? extends TreeNode> currentMeta, Version version) {
            TreeNode ret = super.applyWrite(modification, newValue, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }

        @Override
        protected TreeNode applyTouch(ModifiedNode modification, TreeNode currentMeta, Version version) {
            TreeNode ret = super.applyTouch(modification, currentMeta, version);
            this.enforcer.enforceOnTreeNode(ret);
            return ret;
        }
    }
}

