/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodes;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;
import org.opendaylight.yangtools.yang.data.tree.impl.SchemaAwareApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.node.TreeNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ElementCountConstraintAware;
import org.opendaylight.yangtools.yang.model.api.MandatoryAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MandatoryLeafEnforcer
implements Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(MandatoryLeafEnforcer.class);
    private final ImmutableList<ImmutableList<YangInstanceIdentifier.PathArgument>> mandatoryNodes;

    private MandatoryLeafEnforcer(ImmutableList<ImmutableList<YangInstanceIdentifier.PathArgument>> mandatoryNodes) {
        this.mandatoryNodes = Objects.requireNonNull(mandatoryNodes);
    }

    static @Nullable MandatoryLeafEnforcer forContainer(DataNodeContainer schema, DataTreeConfiguration treeConfig) {
        if (!treeConfig.isMandatoryNodesValidationEnabled()) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        MandatoryLeafEnforcer.findMandatoryNodes((ImmutableList.Builder<ImmutableList<YangInstanceIdentifier.PathArgument>>)builder, YangInstanceIdentifier.of(), schema, treeConfig.getTreeType());
        ImmutableList mandatoryNodes = builder.build();
        return mandatoryNodes.isEmpty() ? null : new MandatoryLeafEnforcer((ImmutableList<ImmutableList<YangInstanceIdentifier.PathArgument>>)mandatoryNodes);
    }

    void enforceOnData(NormalizedNode data) {
        for (ImmutableList path : this.mandatoryNodes) {
            if (NormalizedNodes.findNode((NormalizedNode)data, (Iterable)path).isPresent()) continue;
            throw new IllegalArgumentException(String.format("Node %s is missing mandatory descendant %s", data.name(), YangInstanceIdentifier.of((ImmutableList)path)));
        }
    }

    void enforceOnTreeNode(TreeNode tree) {
        this.enforceOnData(tree.getData());
    }

    private static void findMandatoryNodes(ImmutableList.Builder<ImmutableList<YangInstanceIdentifier.PathArgument>> builder, YangInstanceIdentifier id, DataNodeContainer schema, TreeType type) {
        for (DataSchemaNode child : schema.getChildNodes()) {
            MandatoryAware aware;
            boolean needEnforce;
            if (!SchemaAwareApplyOperation.belongsToTree(type, child)) continue;
            if (child instanceof ContainerSchemaNode) {
                ContainerSchemaNode container = (ContainerSchemaNode)child;
                if (container.isPresenceContainer()) continue;
                MandatoryLeafEnforcer.findMandatoryNodes(builder, id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)container.getQName())), (DataNodeContainer)container, type);
                continue;
            }
            boolean bl = needEnforce = child instanceof MandatoryAware && (aware = (MandatoryAware)child).isMandatory();
            if (!needEnforce && child instanceof ElementCountConstraintAware) {
                aware = (ElementCountConstraintAware)child;
                needEnforce = aware.getElementCountConstraint().map(constraint -> {
                    Integer min = constraint.getMinElements();
                    return min != null && min > 0;
                }).orElse(Boolean.FALSE);
            }
            if (!needEnforce) continue;
            YangInstanceIdentifier desc = id.node((YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)child.getQName()));
            LOG.debug("Adding mandatory child {}", (Object)desc);
            builder.add((Object)ImmutableList.copyOf((Collection)desc.getPathArguments()));
        }
    }
}

