/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeConfiguration;
import org.opendaylight.yangtools.yang.data.tree.api.UniqueConstraintException;
import org.opendaylight.yangtools.yang.data.tree.impl.AbstractValidation;
import org.opendaylight.yangtools.yang.data.tree.impl.BinaryValue;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationApplyOperation;
import org.opendaylight.yangtools.yang.data.tree.impl.ModificationPath;
import org.opendaylight.yangtools.yang.data.tree.impl.UniqueValidationFailedException;
import org.opendaylight.yangtools.yang.data.tree.impl.UniqueValidator;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UniqueValidation
extends AbstractValidation {
    private static final Logger LOG = LoggerFactory.getLogger(UniqueValidation.class);
    private final @NonNull ImmutableList<UniqueValidator<?>> validators;

    private UniqueValidation(ModificationApplyOperation delegate, ImmutableList<UniqueValidator<?>> validators) {
        super(delegate);
        this.validators = Objects.requireNonNull(validators);
    }

    static ModificationApplyOperation of(ListSchemaNode schema, DataTreeConfiguration treeConfig, ModificationApplyOperation delegate) {
        ImmutableList<UniqueValidator<?>> validators = UniqueValidation.validatorsOf(schema, treeConfig);
        return validators.isEmpty() ? delegate : new UniqueValidation(delegate, validators);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    static ImmutableList<UniqueValidator<?>> validatorsOf(ListSchemaNode schema, DataTreeConfiguration treeConfig) {
        @NonNull Collection uniques = schema.getUniqueConstraints();
        if (!treeConfig.isUniqueIndexEnabled() || uniques.isEmpty()) {
            return ImmutableList.of();
        }
        Stopwatch sw = Stopwatch.createStarted();
        HashMap paths = new HashMap();
        ImmutableList validators = (ImmutableList)uniques.stream().map(unique -> UniqueValidator.of((List)((Set)unique.argument()).stream().map(descendant -> paths.computeIfAbsent(descendant, key -> UniqueValidation.toDescendantPath(schema, key))).collect(ImmutableList.toImmutableList()))).collect(ImmutableList.toImmutableList());
        LOG.debug("Constructed {} validators in {}", (Object)validators.size(), (Object)sw);
        return validators;
    }

    @Override
    void enforceOnData(NormalizedNode data) {
        this.enforceOnData(data, (String message, Map<SchemaNodeIdentifier.Descendant, Object> values) -> new UniqueValidationFailedException(message));
    }

    @Override
    void enforceOnData(ModificationPath path, NormalizedNode data) throws UniqueConstraintException {
        this.enforceOnData(data, (String message, Map<SchemaNodeIdentifier.Descendant, Object> values) -> new UniqueConstraintException(path.toInstanceIdentifier(), values, message));
    }

    private <T extends Exception> void enforceOnData(NormalizedNode data, ExceptionSupplier<T> exceptionSupplier) throws T {
        Stopwatch sw = Stopwatch.createStarted();
        Verify.verify((boolean)(data instanceof NormalizedNodeContainer), (String)"Unexpected data %s", (Object)data);
        Collection children = ((NormalizedNodeContainer)data).body();
        HashMultimap collected = HashMultimap.create((int)this.validators.size(), (int)children.size());
        for (NormalizedNode child : children) {
            Verify.verify((boolean)(child instanceof DataContainerNode), (String)"Unexpected child %s", (Object)child);
            DataContainerNode cont = (DataContainerNode)child;
            HashMap<List<YangInstanceIdentifier.NodeIdentifier>, Object> valueCache = new HashMap<List<YangInstanceIdentifier.NodeIdentifier>, Object>();
            for (UniqueValidator validator : this.validators) {
                Object values;
                Object masked;
                if (collected.put((Object)validator, masked = BinaryValue.wrap(values = validator.extractValues(valueCache, cont)))) continue;
                Map<// Could not load outer class - annotation placement on inner may be incorrect
                SchemaNodeIdentifier.Descendant, @Nullable Object> index = validator.indexValues(values);
                throw exceptionSupplier.get(cont.name() + " violates unique constraint on " + masked + " of " + index.keySet(), index);
            }
        }
        LOG.trace("Enforced {} validators in {}", (Object)this.validators.size(), (Object)sw);
    }

    @Override
    MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return super.addToStringAttributes(helper.add("validators", this.validators));
    }

    private static ImmutableList<YangInstanceIdentifier.NodeIdentifier> toDescendantPath(ListSchemaNode parent, SchemaNodeIdentifier.Descendant descendant) {
        List qnames = descendant.getNodeIdentifiers();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)qnames.size());
        Iterator it = descendant.getNodeIdentifiers().iterator();
        ListSchemaNode current = parent;
        while (true) {
            QName qname = (QName)it.next();
            DataSchemaNode next = (DataSchemaNode)current.findDataChildByName(qname).orElseThrow(() -> new IllegalStateException("Cannot find component " + qname + " of " + descendant));
            builder.add((Object)YangInstanceIdentifier.NodeIdentifier.create((QName)qname));
            if (!it.hasNext()) {
                Preconditions.checkState((boolean)(next instanceof TypedDataSchemaNode), (String)"Unexpected schema %s for %s", (Object)next, (Object)descendant);
                ImmutableList ret = builder.build();
                LOG.trace("Resolved {} to {}", (Object)descendant, (Object)ret);
                return ret;
            }
            Preconditions.checkState((boolean)(next instanceof DataNodeContainer), (String)"Unexpected non-container %s for %s", (Object)next, (Object)descendant);
            current = (DataNodeContainer)next;
        }
    }

    @FunctionalInterface
    @NonNullByDefault
    static interface ExceptionSupplier<T extends Exception> {
        public T get(String var1, Map<// Could not load outer class - annotation placement on inner may be incorrect
        SchemaNodeIdentifier.Descendant, @Nullable Object> var2);
    }
}

