/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.spi.node.NormalizedNodePrettyTree;

@Beta
public abstract class AbstractNormalizedNode<I extends YangInstanceIdentifier.PathArgument, T extends NormalizedNode>
implements NormalizedNode,
Immutable {
    private final @NonNull I name;

    protected AbstractNormalizedNode(I name) {
        this.name = (YangInstanceIdentifier.PathArgument)Objects.requireNonNull(name);
    }

    public final I name() {
        return this.name;
    }

    public final PrettyTree prettyTree() {
        return new NormalizedNodePrettyTree(this);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Class<T> clazz = this.implementedType();
        if (!clazz.isInstance(obj)) {
            return false;
        }
        NormalizedNode other = (NormalizedNode)clazz.cast(obj);
        return this.name().equals((Object)other.name()) && this.valueEquals(other);
    }

    public final int hashCode() {
        return 31 * this.name().hashCode() + this.valueHashCode();
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this)).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper toStringHelper) {
        return toStringHelper.add("name", this.name).add("body", this.body());
    }

    protected abstract @NonNull Class<T> implementedType();

    protected abstract int valueHashCode();

    protected abstract boolean valueEquals(@NonNull T var1);
}

