/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node;

import com.google.common.annotations.Beta;
import java.util.Base64;
import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.PrettyTree;
import org.opendaylight.yangtools.concepts.PrettyTreeAware;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;

@Beta
public final class NormalizedNodePrettyTree
extends PrettyTree
implements Immutable {
    private final @NonNull NormalizedNode node;

    public NormalizedNodePrettyTree(@NonNull NormalizedNode node) {
        this.node = Objects.requireNonNull(node);
    }

    public void appendTo(StringBuilder sb, int depth) {
        NormalizedNodePrettyTree.appendNode(sb, depth, null, this.node);
    }

    private static void appendNode(StringBuilder sb, int depth, QNameModule parentNamespace, NormalizedNode node) {
        String simpleName = node.contract().getSimpleName();
        NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
        sb.append(simpleName.toLowerCase(Locale.ROOT).charAt(0)).append(simpleName, 1, simpleName.length()).append(' ');
        QName qname = node.name().getNodeType();
        QNameModule currentNamespace = qname.getModule();
        NormalizedNodePrettyTree.appendNamespace(sb, parentNamespace, currentNamespace);
        sb.append(qname.getLocalName()).append(' ');
        if (node instanceof NormalizedNodeContainer) {
            NormalizedNodeContainer container = (NormalizedNodeContainer)node;
            sb.append("= {");
            Iterator it = container.body().iterator();
            if (it.hasNext()) {
                int childIndent = depth + 1;
                do {
                    sb.append('\n');
                    NormalizedNodePrettyTree.appendNode(sb, childIndent, currentNamespace, (NormalizedNode)it.next());
                } while (it.hasNext());
                sb.append('\n');
                NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
            }
            sb.append('}');
        } else if (node instanceof ValueNode) {
            sb.append("= ");
            Object value = node.body();
            if (value instanceof byte[]) {
                sb.append("(byte[])").append(Base64.getEncoder().encodeToString((byte[])value));
            } else if (value instanceof String) {
                NormalizedNodePrettyTree.appendString(sb, (String)value);
            } else {
                sb.append(value);
            }
        } else if (node instanceof ForeignDataNode) {
            ForeignDataNode data = (ForeignDataNode)node;
            Object body = data.body();
            if (body instanceof PrettyTreeAware) {
                sb.append("= {\n");
                ((PrettyTreeAware)body).prettyTree().appendTo(sb, depth + 1);
                NormalizedNodePrettyTree.appendIndent((StringBuilder)sb, (int)depth);
                sb.append('}');
            } else {
                sb.append("= (").append(data.bodyObjectModel().getName()).append(')');
            }
        } else {
            throw new IllegalStateException("Unhandled node " + node);
        }
    }

    private static boolean appendNamespace(StringBuilder sb, QNameModule parent, QNameModule current) {
        if (!current.equals((Object)parent)) {
            sb.append('(').append(current.getNamespace());
            Optional rev = current.getRevision();
            if (rev.isPresent()) {
                sb.append('@').append(rev.orElseThrow());
            }
            sb.append(')');
            return true;
        }
        return false;
    }

    private static void appendString(StringBuilder sb, String str) {
        sb.append('\"').append(str).append('\"');
    }
}

