/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.yangtools.yang.binding.DataObject;

final class DataChangeListenerAdapter<T extends DataObject>
extends ForwardingObject
implements ClusteredDataTreeChangeListener<T> {
    private final DataChangeListener<T> delegate;

    DataChangeListenerAdapter(DataChangeListener<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void onDataTreeChanged(Collection<DataTreeModification<T>> changes) {
        this.delegate.dataChanged(changes.iterator().next().getRootNode().getDataBefore(), ((DataTreeModification)Iterables.getLast(changes)).getRootNode().getDataAfter());
    }

    @Override
    public void onInitialData() {
        this.delegate.dataChanged(null, null);
    }

    protected DataChangeListener<T> delegate() {
        return this.delegate;
    }
}

