/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.yangtools.yang.binding.DataObject;

final class DataListenerAdapter<T extends DataObject>
extends ForwardingObject
implements ClusteredDataTreeChangeListener<T> {
    private final DataListener<T> delegate;

    DataListenerAdapter(DataListener<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void onDataTreeChanged(Collection<DataTreeModification<T>> changes) {
        this.delegate.dataChangedTo(((DataTreeModification)Iterables.getLast(changes)).getRootNode().getDataAfter());
    }

    @Override
    public void onInitialData() {
        this.delegate.dataChangedTo(null);
    }

    protected DataListener<T> delegate() {
        return this.delegate;
    }
}

