/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.BindingService;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataChangeListenerAdapter;
import org.opendaylight.mdsal.binding.api.DataListener;
import org.opendaylight.mdsal.binding.api.DataListenerAdapter;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public interface DataTreeChangeService
extends BindingService {
    public <T extends DataObject, L extends DataTreeChangeListener<T>> @NonNull ListenerRegistration<L> registerDataTreeChangeListener(@NonNull DataTreeIdentifier<T> var1, @NonNull L var2);

    default public <T extends DataObject> @NonNull Registration registerDataListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataListener<T> listener) {
        return this.registerDataTreeChangeListener(DataTreeChangeService.checkNotWildcard(treeId), new DataListenerAdapter<T>(listener));
    }

    default public <T extends DataObject> @NonNull Registration registerDataChangeListener(@NonNull DataTreeIdentifier<T> treeId, @NonNull DataChangeListener<T> listener) {
        return this.registerDataTreeChangeListener(DataTreeChangeService.checkNotWildcard(treeId), new DataChangeListenerAdapter<T>(listener));
    }

    private static <T extends DataObject> @NonNull DataTreeIdentifier<T> checkNotWildcard(DataTreeIdentifier<T> treeId) {
        @NonNull InstanceIdentifier<T> instanceIdentifier = treeId.getRootIdentifier();
        if (instanceIdentifier.isWildcarded()) {
            throw new IllegalArgumentException("Cannot register listener for wildcard " + instanceIdentifier);
        }
        return treeId;
    }
}

