/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Beta
@NonNullByDefault
public abstract class YangSourceDefinition {
    private final ModuleEffectiveStatement module;

    private YangSourceDefinition(ModuleEffectiveStatement module) {
        this.module = Objects.requireNonNull(module);
    }

    public static Optional<YangSourceDefinition> of(Module module) {
        ModuleEffectiveStatement effective = (ModuleEffectiveStatement)module.asEffectiveStatement();
        return effective.getDeclared() != null ? Optional.of(new Single(effective, (DocumentedNode)module)) : Optional.empty();
    }

    public static Optional<YangSourceDefinition> of(Module module, SchemaNode node) {
        return YangSourceDefinition.of((ModuleEffectiveStatement)module.asEffectiveStatement(), node);
    }

    public static Optional<YangSourceDefinition> of(ModuleEffectiveStatement module, SchemaNode node) {
        return YangSourceDefinition.hasDeclaredStatement(node) ? Optional.of(new Single(module, (DocumentedNode)node)) : Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Optional<YangSourceDefinition> of(ModuleEffectiveStatement module, EffectiveStatement<?, ?> effective) {
        Optional<YangSourceDefinition> optional;
        if (effective instanceof DocumentedNode) {
            DocumentedNode node = (DocumentedNode)effective;
            if (effective.getDeclared() != null) {
                optional = Optional.of(new Single(module, node));
                return optional;
            }
        }
        optional = Optional.empty();
        return optional;
    }

    public static Optional<YangSourceDefinition> of(Module module, Collection<? extends SchemaNode> nodes) {
        Preconditions.checkArgument((!nodes.isEmpty() ? 1 : 0) != 0);
        return nodes.stream().anyMatch(YangSourceDefinition::hasDeclaredStatement) ? Optional.of(new Multiple((ModuleEffectiveStatement)module.asEffectiveStatement(), nodes)) : Optional.empty();
    }

    public final ModuleEffectiveStatement getModule() {
        return this.module;
    }

    private static boolean hasDeclaredStatement(SchemaNode schemaNode) {
        EffectiveStatement effective;
        return schemaNode instanceof EffectiveStatement && (effective = (EffectiveStatement)schemaNode).getDeclared() != null;
    }

    public static final class Single
    extends YangSourceDefinition {
        private final DocumentedNode node;

        Single(ModuleEffectiveStatement module, DocumentedNode node) {
            super(module);
            this.node = Objects.requireNonNull(node);
        }

        public DocumentedNode getNode() {
            return this.node;
        }
    }

    public static final class Multiple
    extends YangSourceDefinition {
        private final List<? extends SchemaNode> nodes;

        Multiple(ModuleEffectiveStatement module, Collection<? extends SchemaNode> nodes) {
            super(module);
            this.nodes = ImmutableList.copyOf(nodes);
        }

        public List<? extends SchemaNode> getNodes() {
            return this.nodes.stream().filter(YangSourceDefinition::hasDeclaredStatement).collect(Collectors.toList());
        }
    }
}

