/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.opendaylight.controller.remote.rpc.RemoteActionImplementation;
import org.opendaylight.controller.remote.rpc.RemoteRpcImplementation;
import org.opendaylight.controller.remote.rpc.registry.ActionRegistry;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMRpcAvailabilityListener;
import org.opendaylight.mdsal.dom.api.DOMRpcIdentifier;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OpsListener
implements DOMRpcAvailabilityListener,
DOMActionAvailabilityExtension.AvailabilityListener {
    private static final Logger LOG = LoggerFactory.getLogger(OpsListener.class);
    private final ActorRef rpcRegistry;
    private final ActorRef actionRegistry;

    OpsListener(ActorRef rpcRegistry, ActorRef actionRegistry) {
        this.rpcRegistry = Objects.requireNonNull(rpcRegistry);
        this.actionRegistry = Objects.requireNonNull(actionRegistry);
    }

    public void onRpcAvailable(Collection<DOMRpcIdentifier> rpcs) {
        Preconditions.checkArgument((rpcs != null ? 1 : 0) != 0, (Object)"Input Collection of DOMRpcIdentifier can not be null.");
        LOG.debug("Adding registration for [{}]", rpcs);
        this.rpcRegistry.tell((Object)new RpcRegistry.Messages.AddOrUpdateRoutes(rpcs), ActorRef.noSender());
    }

    public void onRpcUnavailable(Collection<DOMRpcIdentifier> rpcs) {
        Preconditions.checkArgument((rpcs != null ? 1 : 0) != 0, (Object)"Input Collection of DOMRpcIdentifier can not be null.");
        LOG.debug("Removing registration for [{}]", rpcs);
        this.rpcRegistry.tell((Object)new RpcRegistry.Messages.RemoveRoutes(rpcs), ActorRef.noSender());
    }

    public boolean acceptsImplementation(DOMRpcImplementation impl) {
        return !(impl instanceof RemoteRpcImplementation);
    }

    public boolean acceptsImplementation(DOMActionImplementation impl) {
        return !(impl instanceof RemoteActionImplementation);
    }

    public void onActionsChanged(Set<DOMActionInstance> removed, Set<DOMActionInstance> added) {
        LOG.debug("adding registration for [{}]", added);
        LOG.debug("removing registration for [{}]", removed);
        this.actionRegistry.tell((Object)new ActionRegistry.Messages.UpdateActions(added, removed), ActorRef.noSender());
    }
}

