/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.Address;
import akka.actor.Props;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.controller.remote.rpc.RemoteActionImplementation;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.controller.remote.rpc.RemoteRpcImplementation;
import org.opendaylight.controller.remote.rpc.registry.ActionRegistry;
import org.opendaylight.controller.remote.rpc.registry.RpcRegistry;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcImplementation;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.yangtools.concepts.ObjectRegistration;
import org.opendaylight.yangtools.concepts.Registration;

final class OpsRegistrar
extends AbstractUntypedActor {
    private final Map<Address, ObjectRegistration<DOMRpcImplementation>> rpcRegs = new HashMap<Address, ObjectRegistration<DOMRpcImplementation>>();
    private final Map<Address, ObjectRegistration<DOMActionImplementation>> actionRegs = new HashMap<Address, ObjectRegistration<DOMActionImplementation>>();
    private final DOMRpcProviderService rpcProviderService;
    private final RemoteOpsProviderConfig config;
    private final DOMActionProviderService actionProviderService;

    OpsRegistrar(RemoteOpsProviderConfig config, DOMRpcProviderService rpcProviderService, DOMActionProviderService actionProviderService) {
        this.config = Objects.requireNonNull(config);
        this.rpcProviderService = Objects.requireNonNull(rpcProviderService);
        this.actionProviderService = Objects.requireNonNull(actionProviderService);
    }

    public static Props props(RemoteOpsProviderConfig config, DOMRpcProviderService rpcProviderService, DOMActionProviderService actionProviderService) {
        return Props.create(OpsRegistrar.class, (Object[])new Object[]{Objects.requireNonNull(config), Objects.requireNonNull(rpcProviderService, "DOMRpcProviderService cannot be null"), Objects.requireNonNull(actionProviderService, "DOMActionProviderService cannot be null")});
    }

    public void postStop() throws Exception {
        this.rpcRegs.values().forEach(Registration::close);
        this.rpcRegs.clear();
        this.actionRegs.values().forEach(Registration::close);
        this.actionRegs.clear();
        super.postStop();
    }

    protected void handleReceive(Object message) {
        if (message instanceof RpcRegistry.Messages.UpdateRemoteEndpoints) {
            RpcRegistry.Messages.UpdateRemoteEndpoints updateEndpoints = (RpcRegistry.Messages.UpdateRemoteEndpoints)message;
            this.LOG.debug("Handling updateRemoteEndpoints message");
            this.updateRemoteRpcEndpoints(updateEndpoints.getRpcEndpoints());
        } else if (message instanceof ActionRegistry.Messages.UpdateRemoteActionEndpoints) {
            ActionRegistry.Messages.UpdateRemoteActionEndpoints updateEndpoints = (ActionRegistry.Messages.UpdateRemoteActionEndpoints)message;
            this.LOG.debug("Handling updateRemoteActionEndpoints message");
            this.updateRemoteActionEndpoints(updateEndpoints.getActionEndpoints());
        } else {
            this.unknownMessage(message);
        }
    }

    private void updateRemoteRpcEndpoints(Map<Address, Optional<RpcRegistry.RemoteRpcEndpoint>> rpcEndpoints) {
        ArrayList<ObjectRegistration<DOMRpcImplementation>> prevRegs = new ArrayList<ObjectRegistration<DOMRpcImplementation>>(rpcEndpoints.size());
        for (Map.Entry<Address, Optional<RpcRegistry.RemoteRpcEndpoint>> e : rpcEndpoints.entrySet()) {
            ObjectRegistration<DOMRpcImplementation> prevReg;
            this.LOG.debug("Updating RPC registrations for {}", (Object)e.getKey());
            Optional<RpcRegistry.RemoteRpcEndpoint> maybeEndpoint = e.getValue();
            if (maybeEndpoint.isPresent()) {
                RpcRegistry.RemoteRpcEndpoint endpoint = maybeEndpoint.orElseThrow();
                RemoteRpcImplementation impl = new RemoteRpcImplementation(endpoint.getRouter(), this.config);
                prevReg = this.rpcRegs.put(e.getKey(), (ObjectRegistration<DOMRpcImplementation>)this.rpcProviderService.registerRpcImplementation((DOMRpcImplementation)impl, endpoint.getRpcs()));
            } else {
                prevReg = this.rpcRegs.remove(e.getKey());
            }
            if (prevReg == null) continue;
            prevRegs.add(prevReg);
        }
        prevRegs.forEach(Registration::close);
    }

    private void updateRemoteActionEndpoints(Map<Address, Optional<ActionRegistry.RemoteActionEndpoint>> actionEndpoints) {
        ArrayList<ObjectRegistration<DOMActionImplementation>> prevRegs = new ArrayList<ObjectRegistration<DOMActionImplementation>>(actionEndpoints.size());
        for (Map.Entry<Address, Optional<ActionRegistry.RemoteActionEndpoint>> e : actionEndpoints.entrySet()) {
            ObjectRegistration<DOMActionImplementation> prevReg;
            this.LOG.debug("Updating action registrations for {}", (Object)e.getKey());
            Optional<ActionRegistry.RemoteActionEndpoint> maybeEndpoint = e.getValue();
            if (maybeEndpoint.isPresent()) {
                ActionRegistry.RemoteActionEndpoint endpoint = maybeEndpoint.orElseThrow();
                RemoteActionImplementation impl = new RemoteActionImplementation(endpoint.getRouter(), this.config);
                prevReg = this.actionRegs.put(e.getKey(), (ObjectRegistration<DOMActionImplementation>)this.actionProviderService.registerActionImplementation((DOMActionImplementation)impl, endpoint.getActions()));
            } else {
                prevReg = this.actionRegs.remove(e.getKey());
            }
            if (prevReg == null) continue;
            prevRegs.add(prevReg);
        }
        prevRegs.forEach(Registration::close);
    }
}

