/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.remote.rpc;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.PoisonPill;
import java.util.Objects;
import org.opendaylight.controller.remote.rpc.OpsManager;
import org.opendaylight.controller.remote.rpc.RemoteOpsProviderConfig;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteOpsProvider
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteOpsProvider.class);
    private final DOMRpcProviderService rpcProvisionRegistry;
    private final RemoteOpsProviderConfig config;
    private final ActorSystem actorSystem;
    private final DOMRpcService rpcService;
    private final DOMActionProviderService actionProvisionRegistry;
    private final DOMActionService actionService;
    private ActorRef opsManager;

    public RemoteOpsProvider(ActorSystem actorSystem, DOMRpcProviderService rpcProvisionRegistry, DOMRpcService rpcService, RemoteOpsProviderConfig config, DOMActionProviderService actionProviderService, DOMActionService actionService) {
        this.actorSystem = Objects.requireNonNull(actorSystem);
        this.rpcProvisionRegistry = Objects.requireNonNull(rpcProvisionRegistry);
        this.rpcService = Objects.requireNonNull(rpcService);
        this.config = Objects.requireNonNull(config);
        this.actionProvisionRegistry = Objects.requireNonNull(actionProviderService);
        this.actionService = Objects.requireNonNull(actionService);
    }

    @Override
    public void close() {
        if (this.opsManager != null) {
            LOG.info("Stopping Ops Manager at {}", (Object)this.opsManager);
            this.opsManager.tell((Object)PoisonPill.getInstance(), ActorRef.noSender());
            this.opsManager = null;
        }
    }

    public void start() {
        LOG.info("Starting Remote Ops service...");
        this.opsManager = this.actorSystem.actorOf(OpsManager.props(this.rpcProvisionRegistry, this.rpcService, this.config, this.actionProvisionRegistry, this.actionService), this.config.getRpcManagerName());
        LOG.debug("Ops Manager started at {}", (Object)this.opsManager);
    }
}

